/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.sample;

import org.mentaqueue.AtomicQueue;
import org.mentaqueue.util.Builder;

public class Example {
    public static void main(String[] args) {
        final AtomicQueue<StringBuilder> queue = new AtomicQueue<StringBuilder>(1024, new Builder<StringBuilder>(){

            @Override
            public StringBuilder newInstance() {
                return new StringBuilder(1024);
            }
        });
        Thread producer = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    StringBuilder sb = (StringBuilder)queue.nextToDispatch();
                    sb.setLength(0);
                    sb.append("Hello!");
                    queue.flush();
                    sb = (StringBuilder)queue.nextToDispatch();
                    sb.setLength(0);
                    sb.append("Hi!");
                    sb = (StringBuilder)queue.nextToDispatch();
                    sb.setLength(0);
                    sb.append("Hi again!");
                    queue.flush();
                }
            }
        }, "Thread-Producer");
        Thread consumer = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    long avail;
                    if ((avail = queue.availableToPoll()) <= 0L) {
                        continue;
                    }
                    int i = 0;
                    while ((long)i < avail) {
                        StringBuilder sb = (StringBuilder)queue.poll();
                        ++i;
                    }
                    queue.donePolling();
                }
            }
        }, "Thread-Consumer");
        consumer.start();
        producer.start();
    }
}

