/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.owt;

import java.util.Random;
import java.util.concurrent.locks.LockSupport;
import org.mentaaffinity.Affinity;
import org.mentaqueue.AtomicQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.DetailedBenchmarker;
import org.mentaqueue.wait.SpinWaitStrategy;
import org.tsutils.TSUtils;
import org.tsutils.Timestamper;

public class LatencyTest2 {
    private static final int QUEUE_SIZE = 1024;
    private static final Random RANDOM = new Random();

    public static void main(String[] args) {
        final long messagesToWarmup = Long.parseLong(args[0]);
        final long messagesToTest = Long.parseLong(args[1]);
        final int delayBetweenMessages = Integer.parseInt(args[2]);
        final int messageSize = Integer.parseInt(args[3]);
        final byte[] source = new byte[1024];
        for (int i = 0; i < source.length; ++i) {
            source[i] = (byte)RANDOM.nextInt(100);
        }
        final DetailedBenchmarker bench = new DetailedBenchmarker();
        final AtomicQueue<TransferObject> aToB = new AtomicQueue<TransferObject>(1024, TransferObject.BUILDER);
        final AtomicQueue<TransferObject> bToA = new AtomicQueue<TransferObject>(1024, TransferObject.BUILDER);
        final SpinWaitStrategy producerWaitStrategy = new SpinWaitStrategy();
        final SpinWaitStrategy consumerWaitStrategy = new SpinWaitStrategy();
        final Timestamper timestamper = TSUtils.getTimestamper();
        Thread producer = new Thread(new Runnable(){

            private final void send(boolean warmup) {
                long ts = timestamper.nanoTime();
                TransferObject ml = (TransferObject)aToB.nextToDispatch();
                ml.copy(warmup ? 0L : ts, source, messageSize);
                aToB.flush();
            }

            @Override
            public void run() {
                long avail;
                Affinity.bind();
                this.send(true);
                long count = 0L;
                while (count < messagesToWarmup) {
                    avail = bToA.availableToPoll();
                    if (avail > 0L) {
                        bToA.poll();
                        bToA.donePolling(true);
                        producerWaitStrategy.reset();
                        if (++count >= messagesToWarmup) continue;
                        this.send(true);
                        continue;
                    }
                    producerWaitStrategy.waitForOtherThread();
                }
                this.send(false);
                count = 0L;
                while (count < messagesToTest) {
                    avail = bToA.availableToPoll();
                    if (avail > 0L) {
                        bToA.poll();
                        bToA.donePolling();
                        producerWaitStrategy.reset();
                        if (++count >= messagesToTest) continue;
                        if (delayBetweenMessages == 0) {
                            this.send(false);
                            continue;
                        }
                        if (delayBetweenMessages < 0) {
                            LockSupport.parkNanos(RANDOM.nextInt(-1 * delayBetweenMessages));
                            this.send(false);
                            continue;
                        }
                        LockSupport.parkNanos(delayBetweenMessages);
                        this.send(false);
                        continue;
                    }
                    producerWaitStrategy.waitForOtherThread();
                }
                Affinity.unbind();
                System.out.println(bench.results());
            }
        }, "Thread-Producer");
        Thread consumer = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] target = new byte[1024];
                Affinity.bind();
                while (true) {
                    long avail;
                    if ((avail = aToB.availableToPoll()) > 0L) {
                        TransferObject ml = (TransferObject)aToB.poll();
                        long ts = ml.getTimestamp();
                        byte[] data = ml.getData();
                        int size = ml.getSize();
                        System.arraycopy(data, 0, target, 0, size);
                        aToB.donePolling(true);
                        if (ts > 0L) {
                            bench.measure(timestamper.nanoTime() - ts);
                        }
                        consumerWaitStrategy.reset();
                        TransferObject back = (TransferObject)bToA.nextToDispatch();
                        back.copy(0L, source, 1);
                        bToA.flush();
                        continue;
                    }
                    consumerWaitStrategy.waitForOtherThread();
                }
            }
        }, "Thread-Consumer");
        if (Affinity.isAvailable()) {
            Affinity.assignToProcessor(2, producer);
            Affinity.assignToProcessor(3, consumer);
        } else {
            System.err.println("Thread affinity not available!");
        }
        producer.setDaemon(false);
        consumer.setDaemon(true);
        consumer.start();
        try {
            Thread.sleep(1L);
        }
        catch (Exception e) {
            // empty catch block
        }
        producer.start();
    }

    private static class TransferObject {
        private static final int DEFAULT_CAPACITY = 1024;
        private long timestamp;
        private int size;
        private byte[] data;
        public static final Builder<TransferObject> BUILDER = new Builder<TransferObject>(){

            @Override
            public TransferObject newInstance() {
                return new TransferObject(1024);
            }
        };

        public TransferObject(int capacity) {
            this.data = new byte[capacity];
        }

        public final int getSize() {
            return this.size;
        }

        public final byte[] getData() {
            return this.data;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final void copy(long ts, byte[] src, int size) {
            this.timestamp = ts;
            this.size = size;
            System.arraycopy(src, 0, this.data, 0, size);
        }
    }
}

