/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.owt;

import java.util.Random;
import org.mentaaffinity.Affinity;
import org.mentaqueue.AtomicQueue;
import org.mentaqueue.ConcurrentLinkedQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.DetailedBenchmarker;
import org.mentaqueue.util.PauseSupport;
import org.mentaqueue.wait.SpinWaitStrategy;
import org.tsutils.TSUtils;
import org.tsutils.Timestamper;

public class ConcurrentLinkedQueueTest {
    private static final int QUEUE_SIZE = 1024;
    private static final Random RANDOM = new Random();

    public static void main(String[] args) {
        final long messagesToWarmup = Long.parseLong(args[0]);
        final long messagesToTest = Long.parseLong(args[1]);
        final int delayBetweenMessages = Integer.parseInt(args[2]);
        final DetailedBenchmarker bench = new DetailedBenchmarker();
        final ConcurrentLinkedQueue<MutableLong> aToB = new ConcurrentLinkedQueue<MutableLong>(MutableLong.BUILDER);
        final AtomicQueue<MutableLong> bToA = new AtomicQueue<MutableLong>(1024, MutableLong.BUILDER);
        final SpinWaitStrategy producerWaitStrategy = new SpinWaitStrategy();
        final SpinWaitStrategy consumerWaitStrategy = new SpinWaitStrategy();
        final Timestamper timestamper = TSUtils.getTimestamper();
        Thread producer = new Thread(new Runnable(){

            private final void send(long ts) {
                MutableLong ml = (MutableLong)aToB.nextToDispatch();
                ml.set(ts);
                aToB.flush();
            }

            @Override
            public void run() {
                Affinity.bind();
                this.send(0L);
                long count = 0L;
                long total = messagesToWarmup + messagesToTest;
                while (count < total) {
                    long avail = bToA.availableToPoll();
                    if (avail > 0L) {
                        bToA.poll();
                        bToA.donePolling(true);
                        producerWaitStrategy.reset();
                        long ts = timestamper.nanoTime();
                        if (++count < messagesToWarmup) {
                            this.send(0L);
                            continue;
                        }
                        if (count >= total) continue;
                        if (delayBetweenMessages == 0) {
                            this.send(ts);
                            continue;
                        }
                        if (delayBetweenMessages < 0) {
                            PauseSupport.random(RANDOM.nextInt(-1 * delayBetweenMessages));
                            this.send(timestamper.nanoTime());
                            continue;
                        }
                        PauseSupport.random(delayBetweenMessages);
                        this.send(timestamper.nanoTime());
                        continue;
                    }
                    producerWaitStrategy.waitForOtherThread();
                }
                Affinity.unbind();
                System.out.println(bench.results());
            }
        }, "Thread-Producer");
        Thread consumer = new Thread(new Runnable(){

            @Override
            public void run() {
                Affinity.bind();
                while (true) {
                    long avail;
                    if ((avail = aToB.availableToPoll()) > 0L) {
                        MutableLong ml = (MutableLong)aToB.poll();
                        long ts = ml.get();
                        aToB.donePolling(true);
                        long end = timestamper.nanoTime();
                        if (ts > 0L) {
                            bench.measure(end - ts);
                        }
                        consumerWaitStrategy.reset();
                        MutableLong back = (MutableLong)bToA.nextToDispatch();
                        back.set(ts);
                        bToA.flush();
                        continue;
                    }
                    consumerWaitStrategy.waitForOtherThread();
                }
            }
        }, "Thread-Consumer");
        if (Affinity.isAvailable()) {
            Affinity.assignToProcessor(2, producer);
            Affinity.assignToProcessor(6, consumer);
        } else {
            System.err.println("Thread affinity not available!");
        }
        producer.setDaemon(false);
        consumer.setDaemon(true);
        consumer.start();
        try {
            Thread.sleep(1L);
        }
        catch (Exception e) {
            // empty catch block
        }
        producer.start();
    }

    private static class MutableLong {
        private long value = 0L;
        public static final Builder<MutableLong> BUILDER = new Builder<MutableLong>(){

            @Override
            public MutableLong newInstance() {
                return new MutableLong(-1L);
            }
        };

        public MutableLong(long value) {
            this.value = value;
        }

        public final long get() {
            return this.value;
        }

        public final void set(long value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

