/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.util;

import java.util.ArrayList;
import java.util.List;
import org.mentalog.util.StringUtils;

class StringBuilderPool {
    private static final int SB_SIZE = 32;
    private static final int POOL_SIZE = 16;
    private final List<StringBuilder> sbs = new ArrayList<StringBuilder>(16);
    private int pointer = 0;

    public StringBuilderPool() {
        for (int i = 0; i < 16; ++i) {
            this.sbs.add(new StringBuilder(32));
        }
    }

    public StringBuilder get() {
        if (this.pointer >= this.sbs.size()) {
            return new StringBuilder(32);
        }
        StringBuilder sb = this.sbs.get(this.pointer++);
        sb.setLength(0);
        return sb;
    }

    public final void reset() {
        this.pointer = 0;
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final StringBuilder to_sb(int x) {
        return this.to_sb((long)x);
    }

    public final StringBuilder to_sb(long x) {
        StringBuilder sb = this.get();
        StringUtils.append(sb, x);
        return sb;
    }

    public final StringBuilder to_sb(byte b) {
        return this.to_sb((long)b);
    }

    public final StringBuilder to_sb(short s) {
        return this.to_sb((long)s);
    }

    public final StringBuilder to_sb(double x) {
        StringBuilder sb = this.get();
        StringUtils.append(sb, x);
        return sb;
    }

    public final StringBuilder to_sb(boolean b) {
        StringBuilder sb = this.get();
        if (b) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        return sb;
    }

    public final StringBuilder to_sb(float f) {
        return this.to_sb((double)f);
    }

    public final StringBuilder to_sb(char c) {
        StringBuilder sb = this.get();
        sb.append(c);
        return sb;
    }
}

