/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeFormatter {
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("ddMMyyyy");
    private final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");

    public DateTimeFormatter(TimeZone tz) {
        this.dateFormatter.setTimeZone(tz);
        this.timeFormatter.setTimeZone(tz);
    }

    public DateTimeFormatter() {
        this(TimeZone.getDefault());
    }

    public char[] getDay(long now) {
        Date d = new Date(now);
        String s = this.dateFormatter.format(d);
        return s.substring(0, 2).toCharArray();
    }

    public char[] getMonth(long now) {
        Date d = new Date(now);
        String s = this.dateFormatter.format(d);
        return s.substring(2, 4).toCharArray();
    }

    public char[] getYear(long now) {
        Date d = new Date(now);
        String s = this.dateFormatter.format(d);
        return s.substring(4, 8).toCharArray();
    }

    public void changeTimeZone(TimeZone tz) {
        this.dateFormatter.setTimeZone(tz);
        this.timeFormatter.setTimeZone(tz);
    }

    public char[] formatTime(long timeInMillis) {
        Date d = new Date(timeInMillis);
        String s = this.timeFormatter.format(d);
        return s.toCharArray();
    }

    public void formatTimeTo(StringBuffer sb, long timeInMillis) {
        char[] time = this.formatTime(timeInMillis);
        for (int i = 0; i < time.length; ++i) {
            sb.append(time[i]);
        }
    }

    public static void main(String[] args) {
        DateTimeFormatter formatter = new DateTimeFormatter();
        long now = System.currentTimeMillis();
        System.out.println("F: " + new String(formatter.formatTime(now)));
        System.out.println("DAY: " + new String(formatter.getDay(now)));
        System.out.println("MONTH: " + new String(formatter.getMonth(now)));
        System.out.println("YEAR: " + new String(formatter.getYear(now)));
    }
}

