/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.util;

public class Benchmarker {
    private static final Benchmarker instance = new Benchmarker();
    private static final int DEFAULT_WARMUP = 0;
    private long time;
    private long count = 0L;
    private long totalTime = 0L;
    private long minTime = Long.MAX_VALUE;
    private long maxTime = Long.MIN_VALUE;
    private final int warmup;

    public Benchmarker(int warmup) {
        this.warmup = warmup;
        try {
            Class.forName("java.lang.Math");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Benchmarker() {
        this(0);
    }

    public static final Benchmarker instance() {
        return instance;
    }

    public void reset() {
        this.time = 0L;
        this.count = 0L;
        this.totalTime = 0L;
        this.minTime = Long.MAX_VALUE;
        this.maxTime = Long.MIN_VALUE;
    }

    public void mark() {
        this.time = System.nanoTime();
    }

    public long measure() {
        long lastTime;
        boolean counted;
        if (this.time > 0L && (counted = this.measure(lastTime = System.nanoTime() - this.time))) {
            return lastTime;
        }
        return -1L;
    }

    public boolean measure(long lastTime) {
        if (++this.count > (long)this.warmup) {
            this.totalTime += lastTime;
            this.minTime = Math.min(this.minTime, lastTime);
            this.maxTime = Math.max(this.maxTime, lastTime);
            return true;
        }
        return false;
    }

    private final double avg() {
        long realCount = this.count - (long)this.warmup;
        if (realCount <= 0L) {
            return 0.0;
        }
        double avg = (double)this.totalTime / (double)realCount;
        double rounded = (double)Math.round(avg * 100.0) / 100.0;
        return rounded;
    }

    public String results() {
        StringBuilder sb = new StringBuilder(128);
        long realCount = this.count - (long)this.warmup;
        sb.append("Iterations: ").append(realCount);
        sb.append(" | Avg Time: ").append(String.valueOf(this.avg())).append(" nanos");
        if (realCount > 0L) {
            sb.append(" | Min Time: ").append(this.minTime);
            sb.append(" nanos | Max Time: ").append(this.maxTime);
            sb.append(" nanos");
        }
        return sb.toString();
    }
}

