/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.encoder;

import java.nio.ByteBuffer;
import org.mentalog.encoder.Encoder;

public class ByteOrCharArrayEncoder
implements Encoder {
    @Override
    public boolean encode(Object obj, ByteBuffer bb, int varargsPos, int varargsLen) {
        if (obj instanceof byte[]) {
            byte[] array = (byte[])obj;
            this.parseTrimmedString(array, 0, array.length, bb);
            return true;
        }
        if (obj instanceof char[]) {
            char[] array = (char[])obj;
            this.parseTrimmedString(array, 0, array.length, bb);
            return true;
        }
        return false;
    }

    private final void parseTrimmedString(byte[] src, int position, int length, ByteBuffer bb) {
        int start;
        int end = start + length;
        for (start = position; start < end && src[start] <= 32; ++start) {
        }
        while (end > start && src[end - 1] <= 32) {
            --end;
        }
        if (start >= end) {
            return;
        }
        for (int i = start; i < end; ++i) {
            bb.put(src[i]);
        }
    }

    private final void parseTrimmedString(char[] src, int position, int length, ByteBuffer bb) {
        int start;
        int end = start + length;
        for (start = position; start < end && src[start] <= ' '; ++start) {
        }
        while (end > start && src[end - 1] <= ' ') {
            --end;
        }
        if (start >= end) {
            return;
        }
        for (int i = start; i < end; ++i) {
            bb.put((byte)src[i]);
        }
    }
}

