/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.config;

import java.util.ArrayList;
import java.util.List;
import org.mentalog.config.ConfigParam;

public class ListConfigParam<E>
extends ConfigParam<List<E>> {
    public ListConfigParam(String name, String addParam, String setParam, List<E> defList) {
        super(name, ListConfigParam.copy(defList));
        String[] classes;
        String add = ListConfigParam.getString(addParam, null);
        String set = ListConfigParam.getString(setParam, null);
        if (add != null && set != null) {
            throw new IllegalStateException("Cannot pass both config params: " + addParam + " and " + setParam);
        }
        if (add != null) {
            for (String klass : classes = add.split(",")) {
                this.values().add(this.loadClass(klass));
            }
            this.force();
        }
        if (set != null) {
            ((List)this.value()).clear();
            for (String klass : classes = set.split(",")) {
                this.values().add(this.loadClass(klass));
            }
            this.force();
        }
    }

    public void add(E e, boolean force) {
        ((List)this.value()).add(e);
        if (force) {
            this.force();
        }
    }

    public void add(E e) {
        this.add(e, this.isForceMode());
    }

    public final List<E> values() {
        return (List)this.value();
    }

    @Override
    public void set(List<E> values, boolean force) {
        if (!this.isForced() || force) {
            this.values().clear();
            this.values().addAll(values);
        }
        super.set(this.values(), force);
    }

    @Override
    protected void init(String name) {
    }

    private static final <E> List<E> copy(List<E> list) {
        ArrayList<E> newList = new ArrayList<E>(32);
        if (list == null || list.isEmpty()) {
            return newList;
        }
        for (E e : list) {
            newList.add(e);
        }
        return newList;
    }

    private E loadClass(String s) {
        try {
            Class<?> c = Class.forName(s);
            return (E)c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<E> parseString(String s) {
        throw new UnsupportedOperationException();
    }
}

