/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.config;

import org.mentalog.Log;

public class ConfigParam<E> {
    private static boolean forceMode = false;
    private E value = null;
    private boolean wasForced = false;
    private boolean wasSet = false;
    private final String name;
    private final E defValue;

    public ConfigParam(String name, E defValue) {
        this.name = name;
        this.defValue = defValue;
        this.init(name);
    }

    protected void init(String name) {
        String s = ConfigParam.getString(name, null);
        if (s != null) {
            this.set(this.parseString(s), true);
        }
    }

    protected E parseString(String s) {
        try {
            Class<?> klass = Class.forName(s);
            return (E)klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E getDefault() {
        return this.defValue;
    }

    public static void setForceMode(boolean flag) {
        forceMode = flag;
    }

    protected void force() {
        this.wasForced = true;
    }

    public static void checkAndLog(String name, Object attemptedValue, Object currentValue) {
        if (Log.isShowBypassedConfig() && !ConfigParam.isSame(attemptedValue, currentValue)) {
            Log level = Log.getShowBypassedConfigLevel();
            level.log((Object)"Bypassing configuration!", (Object)"config =", (Object)name, (Object)"attemptedValue =", attemptedValue, (Object)"currentValue =", currentValue);
        }
    }

    private static boolean isSame(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    public void set(E value, boolean force) {
        if (this.wasForced && !force) {
            ConfigParam.checkAndLog(this.name, value, this.value);
            return;
        }
        this.wasSet = true;
        this.wasForced = force;
        this.value = value;
    }

    public final void set(E value) {
        this.set(value, forceMode);
    }

    public final boolean isSet() {
        return this.wasSet;
    }

    public final boolean isForced() {
        return this.wasForced;
    }

    protected final boolean isForceMode() {
        return forceMode;
    }

    public final String getName() {
        return this.name;
    }

    public final E value() {
        if (!this.isSet() && this.defValue != null) {
            return this.defValue;
        }
        return this.value;
    }

    protected static String getString(String name, String def) {
        String[] temp = name.split(",");
        String s = null;
        for (String x : temp) {
            s = System.getenv(x);
            if (s == null) {
                s = System.getProperty(x);
            }
            if (s != null) break;
        }
        if (s == null) {
            return def;
        }
        return s;
    }
}

