/*
 * Decompiled with CFR 0.152.
 */
package org.mentaaffinity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mentaaffinity.Affinity;
import org.mentaaffinity.AffinityException;
import org.mentaaffinity.Chip;
import org.mentaaffinity.Core;
import org.mentaaffinity.Processor;

class CpuInfo {
    static final String DEFAULT_CPUINFO = "/proc/cpuinfo";
    private final boolean hasHyperthreading;
    private final int nChips;
    private final int nProcessors;
    private final int nCores;
    private final List<Chip> chips;
    private static CpuInfo INSTANCE;

    public static void init(String filename) {
        if (INSTANCE == null) {
            INSTANCE = new CpuInfo(filename);
        }
    }

    public static void init() {
        CpuInfo.init(DEFAULT_CPUINFO);
    }

    public static CpuInfo instance() {
        if (INSTANCE == null) {
            throw new AffinityException("CpuInfo is not initialized!");
        }
        return INSTANCE;
    }

    public static void printInfo() {
        System.out.println(CpuInfo.instance().toString());
    }

    private CpuInfo(String filename) {
        int coreId;
        int chipId;
        String[] t;
        ArrayList<String> lines = new ArrayList<String>(256);
        File file = new File(filename);
        if (!file.exists()) {
            throw new AffinityException("Cannot parse file: " + filename);
        }
        try {
            String line;
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                lines.add(line.trim());
            }
            br.close();
            fis.close();
        }
        catch (Exception e) {
            throw new AffinityException("Error parsing file: " + filename, e);
        }
        HashSet<Integer> chips = new HashSet<Integer>();
        for (String line : lines) {
            if (!line.toLowerCase().startsWith("physical id")) continue;
            chips.add(CpuInfo.parseNumber(line));
        }
        this.nChips = chips.size();
        this.nProcessors = CpuInfo.countLines(lines, "processor");
        int check = CpuInfo.getUniqueNumber(lines, "siblings");
        if (this.nProcessors != check) {
            throw new AffinityException("Number of logical processors does not match siblings!");
        }
        this.nCores = CpuInfo.getUniqueNumber(lines, "cpu cores");
        this.hasHyperthreading = this.nCores != this.nProcessors;
        HashSet<Integer> procsToUse = new HashSet<Integer>();
        String toUse = System.getProperty("procsToUse");
        if (toUse != null) {
            String[] s;
            for (String ss : s = toUse.split("\\s*,\\s*")) {
                procsToUse.add(Integer.parseInt(ss));
            }
        }
        String all = CpuInfo.join(lines).trim();
        String[] procBlock = all.split("\n\n");
        HashSet<Processor> allProcessors = new HashSet<Processor>();
        HashSet<String> ensureUnique = new HashSet<String>();
        for (String s : procBlock) {
            t = s.split("\n");
            chipId = CpuInfo.getNumber(t, "physical id");
            coreId = CpuInfo.getNumber(t, "core id");
            int procId = CpuInfo.getNumber(t, "processor");
            String unique = chipId + "-" + coreId + "-" + procId;
            if (ensureUnique.contains(unique)) {
                throw new AffinityException("Found duplicate processor specification: " + unique);
            }
            ensureUnique.add(unique);
            boolean isExcluded = procsToUse.size() > 0 && !procsToUse.contains(procId);
            allProcessors.add(new Processor(procId, chipId, coreId, isExcluded));
        }
        HashSet<String> allCores = new HashSet<String>();
        for (Processor p : allProcessors) {
            allCores.add(p.getChipId() + "-" + p.getCoreId());
        }
        HashSet<Core> theCores = new HashSet<Core>();
        for (String s : allCores) {
            t = s.split("\\-");
            chipId = Integer.parseInt(t[0]);
            coreId = Integer.parseInt(t[1]);
            ArrayList<Processor> procs = new ArrayList<Processor>(2);
            for (Processor p : allProcessors) {
                if (p.getChipId() != chipId || p.getCoreId() != coreId) continue;
                procs.add(p);
            }
            theCores.add(new Core(chipId, coreId, procs));
        }
        HashSet<Integer> allChips = new HashSet<Integer>();
        for (Processor p : allProcessors) {
            allChips.add(p.getChipId());
        }
        ArrayList<Chip> theChips = new ArrayList<Chip>();
        Iterator i$ = allChips.iterator();
        while (i$.hasNext()) {
            chipId = (Integer)i$.next();
            ArrayList<Core> cores = new ArrayList<Core>();
            for (Core c : theCores) {
                if (c.getChipId() != chipId) continue;
                cores.add(c);
            }
            theChips.add(new Chip(chipId, cores));
        }
        this.chips = Collections.unmodifiableList(theChips);
    }

    private static String join(List<String> lines) {
        StringBuilder sb = new StringBuilder(1024);
        for (String line : lines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    public static List<Chip> getChips() {
        return CpuInfo.instance().chips;
    }

    public static Chip getChip() {
        if (CpuInfo.getChips().size() != 1) {
            throw new AffinityException("Your machine has more than one processor!");
        }
        return CpuInfo.getChips().get(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("CpuInfo: [nChips=").append(this.nChips).append(", ");
        sb.append("nCoresPerChip=").append(this.nCores / this.nChips).append(", ");
        sb.append("hyperthreading=").append(this.hasHyperthreading).append(", ");
        sb.append("nProcessors=").append(this.nProcessors).append("]");
        return sb.toString();
    }

    private static int parseNumber(String line) {
        String[] temp = line.split("\\:");
        if (temp.length != 2) {
            throw new AffinityException("Cannot parse id from line: " + line);
        }
        return Integer.parseInt(temp[1].trim());
    }

    private static int countLines(List<String> lines, String s) {
        int x = 0;
        for (String line : lines) {
            if (!line.toLowerCase().startsWith(s)) continue;
            ++x;
        }
        return x;
    }

    private static int getNumber(String[] lines, String s) {
        for (String line : lines) {
            if (!line.toLowerCase().startsWith(s)) continue;
            return CpuInfo.parseNumber(line);
        }
        throw new AffinityException("Cannot find number: " + s);
    }

    private static int getUniqueNumber(List<String> lines, String s) {
        int x = -1;
        for (String line : lines) {
            if (!line.toLowerCase().startsWith(s)) continue;
            int n = CpuInfo.parseNumber(line);
            if (x == -1) {
                x = n;
                continue;
            }
            if (x == n) continue;
            throw new AffinityException("Field is not unique: " + s);
        }
        return x;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            CpuInfo.init();
        } else {
            CpuInfo.init(args[0]);
        }
        CpuInfo.printInfo();
        Affinity.printSituation();
        Thread t1 = new Thread("Thread1"){

            @Override
            public void run() {
                long count;
                Affinity.bind();
                try {
                    count = 0L;
                    while (true) {
                        if (count < Integer.MAX_VALUE) {
                            ++count;
                            continue;
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            Affinity.unbind();
                            return;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Affinity.unbind();
                    throw throwable;
                }
                {
                    count = 0L;
                    continue;
                }
            }
        };
        Thread t2 = new Thread("Thread2"){

            @Override
            public void run() {
                long count;
                Affinity.bind();
                try {
                    count = 0L;
                    while (true) {
                        if (count < Integer.MAX_VALUE) {
                            ++count;
                            continue;
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            Affinity.unbind();
                            return;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Affinity.unbind();
                    throw throwable;
                }
                {
                    count = 0L;
                    continue;
                }
            }
        };
        Affinity.assignToProcessor(1, t1);
        Affinity.assignToProcessor(4, t2);
        Affinity.printSituation();
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }
}

