/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.util;

import org.mentaqueue.util.Builder;

public class TransferObject {
    private static final int DEFAULT_CAPACITY = 1024;
    private long timestamp;
    private int size;
    private byte[] data;
    public static final Builder<TransferObject> BUILDER = new Builder<TransferObject>(){

        @Override
        public TransferObject newInstance() {
            return new TransferObject(1024);
        }
    };

    public TransferObject(int capacity) {
        this.data = new byte[capacity];
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final void copy(byte[] src) {
        this.copy(src, src.length);
    }

    public final void copy(byte[] src, int size) {
        this.timestamp = System.nanoTime();
        this.size = size;
        System.arraycopy(src, 0, this.data, 0, size);
    }
}

