/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.owt;

import java.util.Random;
import java.util.concurrent.locks.LockSupport;
import org.mentaaffinity.Affinity;
import org.mentaqueue.AtomicQueue;
import org.mentaqueue.ConcurrentLinkedQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.DetailedBenchmarker;
import org.mentaqueue.wait.SpinWaitStrategy;

public class ConcurrentLinkedQueueTest {
    private static final int QUEUE_SIZE = 1024;
    private static final Random RANDOM = new Random();

    public static void main(String[] args) {
        final long messagesToWarmup = Long.parseLong(args[0]);
        final long messagesToTest = Long.parseLong(args[1]);
        final int delayBetweenMessages = Integer.parseInt(args[2]);
        final DetailedBenchmarker bench = new DetailedBenchmarker();
        final ConcurrentLinkedQueue<MutableLong> aToB = new ConcurrentLinkedQueue<MutableLong>(MutableLong.BUILDER);
        final AtomicQueue<MutableLong> bToA = new AtomicQueue<MutableLong>(1024, MutableLong.BUILDER);
        final SpinWaitStrategy producerWaitStrategy = new SpinWaitStrategy();
        final SpinWaitStrategy consumerWaitStrategy = new SpinWaitStrategy();
        Thread producer = new Thread(new Runnable(){

            private final void send(boolean warmup) {
                long ts = System.nanoTime();
                MutableLong ml = (MutableLong)aToB.nextToDispatch();
                ml.set(warmup ? 0L : ts);
                aToB.flush();
            }

            @Override
            public void run() {
                long avail;
                Affinity.bind();
                this.send(true);
                long count = 0L;
                while (count < messagesToWarmup) {
                    avail = bToA.availableToPoll();
                    if (avail > 0L) {
                        bToA.poll();
                        bToA.donePolling(true);
                        producerWaitStrategy.reset();
                        if (++count >= messagesToWarmup) continue;
                        this.send(true);
                        continue;
                    }
                    producerWaitStrategy.waitForOtherThread();
                }
                this.send(false);
                count = 0L;
                while (count < messagesToTest) {
                    avail = bToA.availableToPoll();
                    if (avail > 0L) {
                        bToA.poll();
                        bToA.donePolling(true);
                        producerWaitStrategy.reset();
                        if (++count >= messagesToTest) continue;
                        if (delayBetweenMessages == 0) {
                            this.send(false);
                            continue;
                        }
                        if (delayBetweenMessages < 0) {
                            LockSupport.parkNanos(RANDOM.nextInt(-1 * delayBetweenMessages));
                            this.send(false);
                            continue;
                        }
                        LockSupport.parkNanos(delayBetweenMessages);
                        this.send(false);
                        continue;
                    }
                    producerWaitStrategy.waitForOtherThread();
                }
                Affinity.unbind();
                System.out.println(bench.results());
            }
        }, "Thread-Producer");
        Thread consumer = new Thread(new Runnable(){

            @Override
            public void run() {
                Affinity.bind();
                while (true) {
                    long avail;
                    if ((avail = aToB.availableToPoll()) > 0L) {
                        MutableLong ml = (MutableLong)aToB.poll();
                        long ts = ml.get();
                        aToB.donePolling();
                        if (ts > 0L) {
                            bench.measure(System.nanoTime() - ts);
                        }
                        consumerWaitStrategy.reset();
                        MutableLong back = (MutableLong)bToA.nextToDispatch();
                        back.set(ts);
                        bToA.flush();
                        continue;
                    }
                    consumerWaitStrategy.waitForOtherThread();
                }
            }
        }, "Thread-Consumer");
        if (Affinity.isAvailable()) {
            Affinity.assignToProcessor(2, producer);
            Affinity.assignToProcessor(3, consumer);
        } else {
            System.err.println("Thread affinity not available!");
        }
        producer.setDaemon(false);
        consumer.setDaemon(true);
        consumer.start();
        try {
            Thread.sleep(1L);
        }
        catch (Exception e) {
            // empty catch block
        }
        producer.start();
    }

    private static class MutableLong {
        private long value = 0L;
        public static final Builder<MutableLong> BUILDER = new Builder<MutableLong>(){

            @Override
            public MutableLong newInstance() {
                return new MutableLong(-1L);
            }
        };

        public MutableLong(long value) {
            this.value = value;
        }

        public final long get() {
            return this.value;
        }

        public final void set(long value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

