/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.pooled;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class PooledBlockingQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final ConcurrentLinkedQueue<E> pool;
    private final List<E> polledElements;
    private final LinkedList<E> queue;
    private final Object lock = new Object();
    private final int capacity;
    private final E[] temp = new Object[16416];
    private int tempPointer = 0;

    public PooledBlockingQueue(int capacity, Builder<E> builder) {
        this.pool = new ConcurrentLinkedQueue();
        this.polledElements = new LinkedList();
        this.queue = new LinkedList();
        this.capacity = capacity;
        for (int i = 0; i < capacity; ++i) {
            this.pool.offer(builder.newInstance());
        }
    }

    public PooledBlockingQueue(Builder<E> builder) {
        this(16416, builder);
    }

    public PooledBlockingQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public PooledBlockingQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToDispatch() {
        E e = this.pool.poll();
        this.temp[this.tempPointer++] = e;
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean lazySet) {
        Object object = this.lock;
        synchronized (object) {
            boolean wasEmpty = this.queue.isEmpty();
            for (int i = 0; i < this.tempPointer; ++i) {
                int size = this.queue.size();
                while (size == this.capacity) {
                    try {
                        this.lock.wait();
                    }
                    catch (Exception exc) {
                        return;
                    }
                }
                this.queue.add(this.temp[i]);
                this.temp[i] = null;
            }
            if (wasEmpty && this.tempPointer > 0) {
                this.lock.notify();
            }
            this.tempPointer = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long availableToPoll() {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() == 0) {
                try {
                    this.lock.wait();
                }
                catch (Exception e) {
                    return 0L;
                }
            }
            return this.queue.size();
        }
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        E elem;
        Object object = this.lock;
        synchronized (object) {
            elem = this.queue.removeFirst();
            if (this.queue.size() == this.capacity - 1) {
                this.lock.notify();
            }
        }
        this.polledElements.add(elem);
        return elem;
    }

    @Override
    public void donePolling(boolean lazySet) {
        Iterator<E> iter = this.polledElements.iterator();
        while (iter.hasNext()) {
            this.pool.offer(iter.next());
            iter.remove();
        }
    }

    @Override
    public final void donePolling() {
        this.donePolling(true);
    }
}

