/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;
import org.mentaqueue.util.NumberUtils;

public class VolatileQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16384;
    private final int capacity;
    private final E[] data;
    private long nextOfferValue = -1L;
    private long nextPollValue = -1L;
    private volatile long sequence = -1L;
    private volatile long pollingSequence = -1L;
    private long maxSeq;

    public VolatileQueue(int capacity, Builder<E> builder) {
        NumberUtils.ensurePowerOfTwo(capacity);
        this.capacity = capacity;
        this.data = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.data[i] = builder.newInstance();
        }
        this.maxSeq = this.findMaxSeqBeforeWrapping();
    }

    public VolatileQueue(Builder<E> builder) {
        this(16384, builder);
    }

    public VolatileQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public VolatileQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    private final long findMaxSeqBeforeWrapping() {
        return (long)this.capacity + this.pollingSequence;
    }

    @Override
    public E nextToDispatch() {
        long index;
        ++this.nextOfferValue;
        if ((index = this.nextOfferValue--) > this.maxSeq) {
            this.maxSeq = this.findMaxSeqBeforeWrapping();
            if (index > this.maxSeq) {
                return null;
            }
        }
        return this.data[(int)(index & (long)(this.capacity - 1))];
    }

    @Override
    public void flush(boolean lazySet) {
        this.sequence = this.nextOfferValue;
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public long availableToPoll() {
        return this.sequence - this.nextPollValue;
    }

    @Override
    public E poll() {
        return this.data[(int)(++this.nextPollValue & (long)(this.capacity - 1))];
    }

    @Override
    public void donePolling(boolean lazySet) {
        this.pollingSequence = this.nextPollValue;
    }

    @Override
    public final void donePolling() {
        this.donePolling(true);
    }
}

