/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class ConcurrentLinkedQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final java.util.concurrent.ConcurrentLinkedQueue<E> queue;
    private final Builder<E> builder;
    private E elementToReturn = null;
    private final E[] temp = new Object[16416];
    private int tempPointer = 0;

    public ConcurrentLinkedQueue(Builder<E> builder) {
        this.queue = new java.util.concurrent.ConcurrentLinkedQueue();
        this.builder = builder;
    }

    public ConcurrentLinkedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToDispatch() {
        E e = this.builder.newInstance();
        this.temp[this.tempPointer++] = e;
        return e;
    }

    @Override
    public void flush(boolean lazySet) {
        for (int i = 0; i < this.tempPointer; ++i) {
            this.queue.offer(this.temp[i]);
            this.temp[i] = null;
        }
        this.tempPointer = 0;
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public long availableToPoll() {
        this.elementToReturn = this.queue.poll();
        return this.elementToReturn != null ? 1L : 0L;
    }

    @Override
    public E poll() {
        return this.elementToReturn;
    }

    @Override
    public void donePolling(boolean lazySet) {
        this.elementToReturn = null;
    }

    @Override
    public final void donePolling() {
        this.donePolling(true);
    }
}

