/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import org.mentaqueue.BatchingQueue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;
import org.mentaqueue.util.NumberUtils;
import org.mentaqueue.util.PaddedAtomicLong;

public class AtomicQueue<E>
implements BatchingQueue<E> {
    private static final int DEFAULT_CAPACITY = 16384;
    private final int capacity;
    private final E[] data;
    private long nextOfferSequence = -1L;
    private long nextPollSequence = -1L;
    private long maxSequence;
    private final PaddedAtomicLong offerSequence = new PaddedAtomicLong(-1L);
    private final PaddedAtomicLong pollSequence = new PaddedAtomicLong(-1L);

    public AtomicQueue(int capacity, Builder<E> builder) {
        NumberUtils.ensurePowerOfTwo(capacity);
        this.capacity = capacity;
        this.data = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.data[i] = builder.newInstance();
        }
        this.maxSequence = this.findMaxSeqBeforeWrapping();
    }

    public AtomicQueue(Builder<E> builder) {
        this(16384, builder);
    }

    public AtomicQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public AtomicQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    private final long findMaxSeqBeforeWrapping() {
        return (long)this.capacity + this.pollSequence.get();
    }

    @Override
    public final E nextToDispatch() {
        if (++this.nextOfferSequence > this.maxSequence) {
            this.maxSequence = this.findMaxSeqBeforeWrapping();
            if (this.nextOfferSequence > this.maxSequence) {
                --this.nextOfferSequence;
                return null;
            }
        }
        return this.data[(int)(this.nextOfferSequence & (long)(this.capacity - 1))];
    }

    @Override
    public final void flush(boolean lazySet) {
        if (lazySet) {
            this.offerSequence.lazySet(this.nextOfferSequence);
        } else {
            this.offerSequence.set(this.nextOfferSequence);
        }
    }

    @Override
    public final void flush() {
        this.flush(false);
    }

    @Override
    public final long availableToPoll() {
        return this.offerSequence.get() - this.nextPollSequence;
    }

    @Override
    public final E poll() {
        return this.data[(int)(++this.nextPollSequence & (long)(this.capacity - 1))];
    }

    @Override
    public final void donePolling(boolean lazySet) {
        if (lazySet) {
            this.pollSequence.lazySet(this.nextPollSequence);
        } else {
            this.pollSequence.set(this.nextPollSequence);
        }
    }

    @Override
    public final void donePolling() {
        this.donePolling(true);
    }
}

