/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.util;

import java.util.Arrays;

class StringUtils {
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final String MIN_VALUE_TEXT = "-9223372036854775808";
    static final long[] TENS = new long[19];

    StringUtils() {
    }

    public static final boolean equal(CharSequence sb1, CharSequence sb2) {
        if (sb1.length() == sb2.length()) {
            for (int i = 0; i < sb1.length(); ++i) {
                if (sb1.charAt(i) == sb2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean equal(CharSequence sb, String s) {
        if (sb.length() == s.length()) {
            for (int i = 0; i < s.length(); ++i) {
                if (sb.charAt(i) == s.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final int indexOf(CharSequence sb, int start, char c) {
        for (int i = start; i < sb.length(); ++i) {
            if (sb.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(CharSequence sb, char c) {
        return StringUtils.indexOf(sb, 0, c);
    }

    public static final void copy(CharSequence sb, byte[] dst) {
        if (sb.length() > dst.length) {
            throw new RuntimeException("Byte array is not big enough!");
        }
        for (int i = 0; i < sb.length(); ++i) {
            dst[i] = (byte)sb.charAt(i);
        }
    }

    public static final void copy(char[] array, StringBuilder sb) {
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
        }
    }

    public static final void copy(CharSequence sb1, int start, int end, StringBuilder sb2) {
        int len = end - start;
        for (int i = 0; i < len; ++i) {
            sb2.append(sb1.charAt(start + i));
        }
    }

    public static final void copy(CharSequence sb1, StringBuilder sb2) {
        StringUtils.copy(sb1, 0, sb1.length(), sb2);
    }

    public static final void copy(CharSequence sb1, int end, StringBuilder sb2) {
        StringUtils.copy(sb1, 0, end, sb2);
    }

    public static final boolean isBlank(CharSequence sb, int start, int end) {
        int len = end - start;
        for (int i = 0; i < len; ++i) {
            if (sb.charAt(start + i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static final boolean isBlank(CharSequence sb, int end) {
        return StringUtils.isBlank(sb, 0, end);
    }

    public static final boolean isBlank(CharSequence sb) {
        return StringUtils.isBlank(sb, 0, sb.length());
    }

    public static final void trim(StringBuilder sb) {
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    private static long power10(long l) {
        int idx = Arrays.binarySearch(TENS, l);
        return idx >= 0 ? TENS[idx] : TENS[~idx - 1];
    }

    private static void appendLong0(StringBuilder sb, long num) {
        for (long power10 = StringUtils.power10(num); power10 > 0L; power10 /= 10L) {
            sb.append((char)(num / power10 % 10L + 48L));
        }
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value += (long)modDiv * mod / 5L;
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    public static final StringBuilder append(StringBuilder sb, double d) {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            sb.append('-');
        }
        if (exp == 0 && mantissa == 0L) {
            sb.append('0');
            return sb;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                sb.append("Infinity");
            } else {
                sb.append("NaN");
            }
            return sb;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                StringUtils.appendLong0(sb, intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    sb.append('.');
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        sb.append((char)(48L + num));
                        double parsedValue = StringUtils.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                }
                return sb;
            }
            sb.append('0');
            sb.append('.');
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    sb.append('0');
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                sb.append(c);
                mantissa -= num << precision;
                double parsedValue = StringUtils.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return sb;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        StringUtils.appendLong0(sb, val2);
        for (int i = 0; i < digits; ++i) {
            sb.append('0');
        }
        return sb;
    }

    public static final StringBuilder append(StringBuilder sb, long num) {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                sb.append(MIN_VALUE_TEXT);
                return sb;
            }
            sb.append('-');
            num = -num;
        }
        if (num == 0L) {
            sb.append('0');
        } else {
            StringUtils.appendLong0(sb, num);
        }
        return sb;
    }

    public static void main(String[] args) {
        double d = 234.34232022;
        StringBuilder sb = new StringBuilder(32);
        StringUtils.append(sb, d);
        System.out.println(sb);
        sb.setLength(0);
        StringUtils.append(sb, 123456789L);
        System.out.println(sb);
    }

    static {
        StringUtils.TENS[0] = 1L;
        for (int i = 1; i < TENS.length; ++i) {
            StringUtils.TENS[i] = TENS[i - 1] * 10L;
        }
    }
}

