/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.test;

import org.apache.log4j.PropertyConfigurator;
import org.mentalog.Log;
import org.mentalog.test.GCTest;
import org.mentalog.util.Benchmarker;
import org.mentalog.util.DetailedBenchmarker;
import org.mentalog.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceComparator {
    private static final String MSG = "This is a log message not so small that you can use to test. I hope you have fun and it works well!";
    private static final String FORMAT = "format HeapTest <max> <mentalog|log4j|logback>";
    private static Logger logger_logback = null;
    private static org.apache.log4j.Logger logger_log4j = null;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println(FORMAT);
            return;
        }
        LogLibrary logLibrary = null;
        try {
            logLibrary = Enum.valueOf(LogLibrary.class, args[1].toUpperCase());
        }
        catch (Exception e) {
            System.err.println("Cannot parse log library: " + args[1]);
            System.out.println(FORMAT);
            return;
        }
        int max = Integer.parseInt(args[0]);
        int warmup = (int)Math.round(0.1 * (double)max);
        long totalMemory = 0L;
        long logsWithNoMemory = 0L;
        long logsWithMemory = 0L;
        long logsTotal = 0L;
        long logsGC = 0L;
        boolean isDetailed = SystemUtils.getBoolean("detailedBenchmark", false);
        DetailedBenchmarker bench = isDetailed ? new DetailedBenchmarker(warmup) : new DetailedBenchmarker(warmup);
        PerformanceComparator.setup(logLibrary);
        System.out.println("Performing GC before starting...");
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Starting...");
        long freeMemory = 0L;
        long mem = 0L;
        for (int i = 1; i <= max; ++i) {
            freeMemory = Runtime.getRuntime().freeMemory();
            bench.mark();
            PerformanceComparator.log(logLibrary);
            bench.measure();
            mem = freeMemory - Runtime.getRuntime().freeMemory();
            ++logsTotal;
            if (mem > 0L) {
                totalMemory += mem;
                ++logsWithMemory;
                continue;
            }
            if (mem == 0L) {
                ++logsWithNoMemory;
                continue;
            }
            ++logsGC;
        }
        Log.stop();
        System.out.println("Wrote " + logsTotal + " log lines to a file!");
        if (!isDetailed) {
            System.out.println("Logs that allocated memory: " + logsWithMemory + " (" + PerformanceComparator.p(logsWithMemory, logsTotal) + ")");
            System.out.println("Logs that did not allocate any memory: " + logsWithNoMemory + " (" + PerformanceComparator.p(logsWithNoMemory, logsTotal) + ")");
            System.out.println("Logs that triggered GC: " + logsGC + " (" + PerformanceComparator.p(logsGC, logsTotal) + ")");
            System.out.println("Memory allocated: " + totalMemory + " bytes");
        }
        System.out.println("Benchmark: " + ((Benchmarker)bench).results());
        System.out.println();
    }

    private static final void setup(LogLibrary logLibrary) {
        if (logLibrary == LogLibrary.MENTALOG) {
            Log.setFile(true);
            Log.Warn.log((Object)MSG);
        } else if (logLibrary == LogLibrary.LOGBACK) {
            logger_logback = LoggerFactory.getLogger("chapters.introduction.HelloWorld1");
            logger_logback.warn(MSG);
        } else if (logLibrary == LogLibrary.LOG4J) {
            PropertyConfigurator.configure("./src/main/java/org/mentalog/test/log4j.xml");
            logger_log4j = org.apache.log4j.Logger.getLogger(GCTest.class);
            logger_log4j.warn(MSG);
        }
    }

    private static final void log(LogLibrary logLibrary) {
        if (logLibrary == LogLibrary.MENTALOG) {
            Log.Warn.log((Object)MSG);
        } else if (logLibrary == LogLibrary.LOGBACK) {
            logger_logback.warn(MSG);
        } else if (logLibrary == LogLibrary.LOG4J) {
            logger_log4j.warn(MSG);
        }
    }

    private static String p(long l, long total) {
        double d = (double)l / (double)total * 100.0;
        double rounded = (double)Math.round(d * 100.0) / 100.0;
        return String.valueOf(rounded) + "%";
    }

    private static enum LogLibrary {
        LOG4J,
        MENTALOG,
        LOGBACK;

    }
}

