/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog.encoder;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.mentalog.encoder.Encoder;

public class ThrowableEncoder
implements Encoder {
    @Override
    public boolean encode(Object obj, ByteBuffer bb, int varargsPos, int varargsLen) {
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            if (varargsPos == varargsLen - 1) {
                String s = ThrowableEncoder.getStackTrace(t);
                bb.put((byte)10);
                ThrowableEncoder.transfer(s, bb);
            } else {
                ThrowableEncoder.transferToString(t, bb);
            }
            return true;
        }
        return false;
    }

    private static final void transfer(CharSequence s, ByteBuffer bb) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            bb.put((byte)s.charAt(i));
        }
    }

    private static final void transferToString(Throwable t, ByteBuffer bb) {
        ThrowableEncoder.transfer(t.getClass().getName(), bb);
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            bb.put((byte)58);
            bb.put((byte)32);
            ThrowableEncoder.transfer(msg, bb);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }
}

