/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog;

public class LogException
extends RuntimeException {
    protected final Throwable rootCause;

    public LogException() {
        this.rootCause = null;
    }

    public LogException(Throwable e) {
        super(LogException.getMsg(e), e);
        Throwable root = LogException.getRootCause(e);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    public LogException(String msg) {
        super(msg);
        this.rootCause = null;
    }

    public LogException(String msg, Throwable e) {
        super(msg, e);
        Throwable root = LogException.getRootCause(e);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    private static String getMsg(Throwable t) {
        Throwable root = LogException.getRootCause(t);
        String msg = root.getMessage();
        if (!(msg != null && msg.length() != 0 || (msg = t.getMessage()) != null && msg.length() != 0)) {
            return root.getClass().getName();
        }
        return msg;
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable root = t.getCause();
        if (root == null) {
            return t;
        }
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    @Override
    public Throwable getCause() {
        return this.rootCause;
    }
}

