/*
 * Decompiled with CFR 0.152.
 */
package org.mentalog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.mentalog.AsciiEncodable;
import org.mentalog.AsyncThread;
import org.mentalog.Log;
import org.mentalog.LogEvent;
import org.mentalog.LogException;
import org.mentalog.LogMessageBuilder;
import org.mentalog.Logger;
import org.mentalog.encoder.Encoder;
import org.mentalog.interceptor.Interceptor;
import org.mentalog.timestamper.Timestamper;
import org.mentalog.util.Benchmarker;
import org.mentalog.util.LogEventUtils;
import org.mentalog.util.StringBuilderUtils;

class DefaultLogger
implements Logger {
    private static final byte[] HEADER_START = "LOG OPENED - ".getBytes();
    private static final byte[] COLOR_CLOSING = "\u001b[0m".getBytes();
    private PrintStream printStream;
    private boolean enabled = true;
    private byte[] prefix = null;
    private final StringBuffer sb = new StringBuffer(128);
    private final String filename;
    private final boolean isSystemOutOrErr;
    private final boolean isSynchronized;
    private final byte[] color;
    private final Timestamper timestamper;
    private final List<Encoder> encoders;
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>(8);
    private final Log level;
    private final boolean isMemoryMapped;
    private final boolean isAsynchronous = Log.isAsynchronous();
    protected ByteBuffer buffer;
    protected FileChannel fileChannel;
    protected RandomAccessFile raf = null;
    protected File outputFile = null;
    private final Object[] oa1 = new Object[1];
    private Object[] oa2 = new Object[2];
    private Object[] oa3 = new Object[3];
    private Object[] oa4 = new Object[4];
    private Object[] oa5 = new Object[5];
    private Object[] oa6 = new Object[6];
    private Object[] oa7 = new Object[7];
    private Object[] oa8 = new Object[8];
    private Object[] oa9 = new Object[9];
    private Object[] oa10 = new Object[10];
    private Object[] oa11 = new Object[11];
    private Object[] oa12 = new Object[12];
    private Object[] oa13 = new Object[13];
    private Object[] oa14 = new Object[14];
    private Object[] oa15 = new Object[15];
    private Object[] oa16 = new Object[16];

    DefaultLogger(String filename, Timestamper timestamper, boolean isSynchronized, boolean isMemoryMapped, int memoryMappedBufferSize, List<Encoder> encoders, Log level) throws IOException {
        this.color = null;
        this.level = level;
        this.encoders = encoders;
        this.timestamper = timestamper;
        this.isSynchronized = isSynchronized;
        this.isSystemOutOrErr = false;
        this.filename = filename;
        this.printStream = null;
        this.outputFile = new File(filename);
        this.isMemoryMapped = isMemoryMapped;
        if (isMemoryMapped) {
            this.buffer = this.createMappedByteBuffer(this.outputFile, memoryMappedBufferSize);
        } else {
            this.fileChannel = new FileOutputStream(this.outputFile, true).getChannel();
            this.buffer = ByteBuffer.allocateDirect(Log.getBufferSize());
        }
        this.prefix = null;
        this.printTopHeader(this.outputFile.length() == 0L);
        this.addShutdownHook();
    }

    DefaultLogger(String dir, String filename, Timestamper timestamper, boolean isSynchronized, boolean isMemoryMapped, int memoryMappedBufferSize, List<Encoder> encoders, Log level) throws IOException {
        this.color = null;
        this.level = level;
        this.encoders = encoders;
        this.timestamper = timestamper;
        this.isSynchronized = isSynchronized;
        this.isSystemOutOrErr = false;
        if (dir == null || dir.trim().equals("")) {
            this.sb.append("");
        } else if (!dir.endsWith(File.separator) && !filename.startsWith(File.separator)) {
            this.sb.append(dir).append(File.separator);
        }
        this.sb.append(filename);
        this.filename = this.sb.toString();
        this.printStream = null;
        this.outputFile = new File(this.filename);
        this.isMemoryMapped = isMemoryMapped;
        if (isMemoryMapped) {
            this.buffer = this.createMappedByteBuffer(this.outputFile, memoryMappedBufferSize);
        } else {
            this.fileChannel = new FileOutputStream(this.outputFile, true).getChannel();
            this.buffer = ByteBuffer.allocateDirect(Log.getBufferSize());
        }
        this.prefix = null;
        this.printTopHeader(this.outputFile.length() == 0L);
        this.addShutdownHook();
    }

    DefaultLogger(PrintStream stream, String prefix, Timestamper timestamper, boolean isSynchronized, byte[] color, List<Encoder> encoders, Log level) {
        this.color = color;
        this.level = level;
        this.encoders = encoders;
        this.timestamper = timestamper;
        this.isSynchronized = isSynchronized;
        this.isSystemOutOrErr = stream == System.out || stream == System.err;
        this.filename = null;
        this.fileChannel = null;
        this.buffer = ByteBuffer.allocateDirect(Log.getBufferSize());
        this.isMemoryMapped = false;
        this.printStream = stream;
        byte[] byArray = this.prefix = prefix != null ? prefix.getBytes() : null;
        if (!this.isSystemOutOrErr) {
            this.addShutdownHook();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DefaultLogger.this.close();
            }
        });
    }

    protected MappedByteBuffer createMappedByteBuffer(File file, int size) {
        this.throwException();
        return null;
    }

    public String toString() {
        if (this.filename != null) {
            return "DefaultLogger: filename=" + this.filename;
        }
        if (this.printStream == System.out) {
            return "DefaultLogger: stream=System.out";
        }
        if (this.printStream == System.err) {
            return "DefaultLogger: stream=System.err";
        }
        return "DefaultLogger: stream=" + this.printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterceptor(Interceptor interceptor) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.interceptors.add(interceptor);
            }
        } else {
            this.interceptors.add(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(Interceptor interceptor) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.interceptors.remove(interceptor);
            }
        } else {
            this.interceptors.remove(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.closeImpl();
            }
        } else {
            this.closeImpl();
        }
    }

    private void closeImpl() {
        if (this.isSystemOutOrErr) {
            return;
        }
        try {
            if (this.isMemoryMapped) {
                this.forceAllMemoryMappedBuffers();
            } else {
                if (this.fileChannel != null) {
                    this.flushByteBuffer();
                    this.fileChannel.close();
                }
                if (this.printStream != null) {
                    this.printStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(boolean b) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.enabled = b;
            }
        } else {
            this.enabled = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void roll() {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.rollImpl();
            }
        } else {
            this.rollImpl();
        }
    }

    private final void throwException() {
        throw new IllegalStateException("Memory-mapped files are not supported. Check http://mentalog.soliveirajr.com for details on how to activate it.");
    }

    protected void forceAllMemoryMappedBuffers() {
        this.throwException();
    }

    private void rollImpl() {
        if (this.outputFile == null || !this.outputFile.exists()) {
            return;
        }
        this.closeImpl();
        this.sb.delete(0, this.sb.length());
        this.sb.append(this.outputFile.getAbsolutePath());
        this.printRollDateTime(this.sb);
        String rollFilename = this.sb.toString();
        this.outputFile.renameTo(new File(rollFilename));
        this.outputFile = new File(this.filename);
        try {
            this.fileChannel = new FileOutputStream(this.outputFile, false).getChannel();
            this.printTopHeader(this.outputFile.length() == 0L);
        }
        catch (Exception e) {
            throw new LogException("Error rolling log file!", e);
        }
    }

    private void printTopHeaderDateTime(StringBuffer sb) {
        long now = System.currentTimeMillis();
        char[] dd = Log.DATETIME_FORMATTER.getDay(now);
        char[] MM = Log.DATETIME_FORMATTER.getMonth(now);
        char[] yyyy = Log.DATETIME_FORMATTER.getYear(now);
        this.printTo(sb, dd);
        sb.append('/');
        this.printTo(sb, MM);
        sb.append('/');
        this.printTo(sb, yyyy);
        sb.append(' ');
        Log.DATETIME_FORMATTER.formatTimeTo(sb, now);
    }

    private void printRollDateTime(StringBuffer sb) {
        long now = System.currentTimeMillis();
        char[] dd = Log.DATETIME_FORMATTER.getDay(now);
        char[] MM = Log.DATETIME_FORMATTER.getMonth(now);
        char[] yyyy = Log.DATETIME_FORMATTER.getYear(now);
        sb.append('-');
        this.printTo(sb, yyyy);
        this.printTo(sb, MM);
        this.printTo(sb, dd);
        sb.append('-');
        char[] time = Log.DATETIME_FORMATTER.formatTime(now);
        this.printTo(sb, time, 0, 2);
        this.printTo(sb, time, 3, 2);
        this.printTo(sb, time, 6, 2);
    }

    private final void printTo(StringBuffer sb, char[] c) {
        for (int i = 0; i < c.length; ++i) {
            sb.append(c[i]);
        }
    }

    private final void printTo(StringBuffer sb, char[] c, int pos, int length) {
        for (int i = pos; i < pos + length; ++i) {
            sb.append(c[i]);
        }
    }

    protected void printTopHeader(boolean newFile) {
        this.sb.delete(0, this.sb.length());
        this.printTopHeaderDateTime(this.sb);
        if (!newFile) {
            this.buffer.put((byte)10);
        }
        this.buffer.put(HEADER_START);
        DefaultLogger.transferStringBufferToByteBuffer(this.sb, this.buffer);
        this.buffer.put((byte)10);
        this.flushByteBuffer();
    }

    protected void flushForMemoryMappedBuffer() {
        this.throwException();
    }

    private void flushByteBuffer() {
        if (this.buffer.position() > 0) {
            if (this.isMemoryMapped) {
                this.flushForMemoryMappedBuffer();
            } else {
                this.buffer.flip();
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.write(this.buffer);
                    }
                    catch (Exception e) {
                        throw new LogException("Error writting to log file!", e);
                    }
                    if (this.buffer.hasRemaining()) {
                        throw new LogException("Failed to write buffer to file!");
                    }
                } else if (this.printStream != null) {
                    int rem = this.buffer.remaining();
                    for (int i = 0; i < rem; ++i) {
                        this.printStream.write(this.buffer.get());
                    }
                    this.printStream.flush();
                }
                this.buffer.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void header(long timestamp) {
        long timeInMillis = this.timestamper.getPrecision() == Timestamper.Precision.MICROS ? timestamp / 1000L : (this.timestamper.getPrecision() == Timestamper.Precision.NANOS ? timestamp / 1000000L : timestamp);
        this.sb.delete(0, this.sb.length());
        Log.DATETIME_FORMATTER.formatTimeTo(this.sb, timeInMillis);
        if (this.timestamper.getPrecision() == Timestamper.Precision.MICROS) {
            long extraMicros = timestamp - timeInMillis * 1000L;
            if (extraMicros == 0L) {
                this.sb.append("000");
            } else if (extraMicros < 10L) {
                this.sb.append("00").append(extraMicros);
            } else if (extraMicros < 100L) {
                this.sb.append("0").append(extraMicros);
            } else if (extraMicros < 1000L) {
                this.sb.append(extraMicros);
            } else {
                if (extraMicros != 1000L) throw new LogException("Got a bad micro time: " + extraMicros);
                this.sb.append("999");
            }
        } else if (this.timestamper.getPrecision() == Timestamper.Precision.NANOS) {
            long extraNanos = timestamp - timeInMillis * 1000L * 1000L;
            if (extraNanos == 0L) {
                this.sb.append("000000");
            } else if (extraNanos < 10L) {
                this.sb.append("00000").append(extraNanos);
            } else if (extraNanos < 100L) {
                this.sb.append("0000").append(extraNanos);
            } else if (extraNanos < 1000L) {
                this.sb.append("000");
            } else if (extraNanos < 10000L) {
                this.sb.append("00");
            } else if (extraNanos < 100000L) {
                this.sb.append("0");
            } else if (extraNanos < 1000000L) {
                this.sb.append(extraNanos);
            } else {
                if (extraNanos != 1000000L) throw new LogException("Got a bad nano time: " + extraNanos);
                this.sb.append("999999");
            }
        }
        DefaultLogger.transferStringBufferToByteBuffer(this.sb, this.buffer);
        if (this.prefix == null) return;
        this.buffer.put((byte)45);
        this.buffer.put(this.prefix);
    }

    private static final void transferStringBufferToByteBuffer(StringBuffer sb, ByteBuffer bb) {
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            bb.put((byte)sb.charAt(i));
        }
    }

    private static final void transferCharSequenceToByteBuffer(CharSequence s, ByteBuffer bb) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            bb.put((byte)s.charAt(i));
        }
    }

    @Override
    public void log(Object ... objects) {
        this.log(this.isAsynchronous, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(boolean async, Object ... objects) {
        if (Log.isBenchmark()) {
            Benchmarker.instance().mark();
        }
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                if (async) {
                    AsyncThread.logLater(this, objects);
                } else {
                    this.logImpl(objects);
                }
            }
        } else if (async) {
            AsyncThread.logLater(this, objects);
        } else {
            this.logImpl(objects);
        }
    }

    private static final StackTraceElement findCorrectElement(StackTraceElement[] stack) {
        for (int i = 1; i < stack.length; ++i) {
            StackTraceElement elem = stack[i];
            String klass = elem.getClassName();
            if (klass.equals(Log.class.getName()) || klass.equals(DefaultLogger.class.getName())) continue;
            return elem;
        }
        return null;
    }

    private final void logImpl(Object ... objects) {
        int i;
        StackTraceElement[] stack;
        StackTraceElement elem;
        StringBuilderUtils.reset();
        if (objects == null || objects.length == 0) {
            throw new IllegalStateException("Cannot log null or zero length array!");
        }
        if (!this.enabled) {
            return;
        }
        boolean shouldFilter = false;
        if (Log.getFilter() != null) {
            shouldFilter = true;
            String[] filter = Log.getFilter();
            StackTraceElement[] stack2 = Thread.currentThread().getStackTrace();
            StackTraceElement elem2 = DefaultLogger.findCorrectElement(stack2);
            if (elem2 == null) {
                return;
            }
            String klass = elem2.getClassName();
            for (String f : filter) {
                if (f.equals("*")) {
                    shouldFilter = false;
                    break;
                }
                if (f.endsWith("*")) {
                    if (!klass.startsWith(f = f.substring(0, f.length() - 1))) continue;
                    shouldFilter = false;
                    break;
                }
                if (!klass.equals(f)) continue;
                shouldFilter = false;
                break;
            }
        }
        if (shouldFilter) {
            return;
        }
        if (this.color != null) {
            this.buffer.put(this.color);
        }
        this.header(this.timestamper.getTimestamp());
        if (Log.isShowClassAndLineNumber() && (elem = DefaultLogger.findCorrectElement(stack = Thread.currentThread().getStackTrace())) != null) {
            this.buffer.put((byte)45);
            DefaultLogger.transferCharSequenceToByteBuffer(elem.getClassName(), this.buffer);
            this.buffer.put((byte)58);
            DefaultLogger.transferCharSequenceToByteBuffer(String.valueOf(elem.getLineNumber()), this.buffer);
        }
        this.buffer.put((byte)32);
        int count = 0;
        boolean lastObjectEndsWithEqualSign = false;
        int currPlaceholderIndex = -1;
        CharSequence placeholderCharSequence = null;
        for (int varargsPos = 0; varargsPos < objects.length; ++varargsPos) {
            CharSequence cs;
            Object object = objects[varargsPos];
            if (varargsPos == 0 && objects.length > 0 && object instanceof CharSequence && (currPlaceholderIndex = DefaultLogger.indexOfPlaceholder(cs = (CharSequence)object, 0)) >= 0) {
                placeholderCharSequence = cs;
                DefaultLogger.copySubstring(placeholderCharSequence, this.buffer, 0, currPlaceholderIndex, true);
                continue;
            }
            if (!(count++ <= 0 || placeholderCharSequence != null || Log.isNoSpaceAfterEqualSign() && lastObjectEndsWithEqualSign || Log.isNoSpaceBetweenObjects())) {
                this.buffer.put((byte)32);
            }
            lastObjectEndsWithEqualSign = false;
            boolean foundEncoder = false;
            if (this.encoders != null) {
                int len = this.encoders.size();
                for (i = len - 1; i >= 0; --i) {
                    if (!this.encoders.get(i).encode(object, this.buffer, varargsPos, objects.length)) continue;
                    foundEncoder = true;
                    break;
                }
            }
            if (!foundEncoder) {
                DefaultLogger.transferCharSequenceToByteBuffer(object.toString(), this.buffer);
            }
            if (placeholderCharSequence != null) {
                int nextPlaceholderIndex = DefaultLogger.indexOfPlaceholder(placeholderCharSequence, currPlaceholderIndex + 2);
                if (nextPlaceholderIndex == -1) {
                    if (currPlaceholderIndex + 2 >= placeholderCharSequence.length()) break;
                    DefaultLogger.copySubstring(placeholderCharSequence, this.buffer, currPlaceholderIndex + 2, placeholderCharSequence.length(), false);
                    break;
                }
                if (varargsPos == objects.length - 1) {
                    DefaultLogger.copySubstring(placeholderCharSequence, this.buffer, currPlaceholderIndex + 2, placeholderCharSequence.length(), false);
                } else {
                    DefaultLogger.copySubstring(placeholderCharSequence, this.buffer, currPlaceholderIndex + 2, nextPlaceholderIndex, true);
                    currPlaceholderIndex = nextPlaceholderIndex;
                }
            }
            if (!Log.isNoSpaceAfterEqualSign() || !(object instanceof CharSequence) || placeholderCharSequence != null) continue;
            CharSequence cs2 = (CharSequence)object;
            lastObjectEndsWithEqualSign = cs2.length() > 0 && cs2.charAt(cs2.length() - 1) == '=';
        }
        if (this.color != null) {
            this.buffer.put(COLOR_CLOSING);
        }
        boolean aborted = false;
        if (this.interceptors != null) {
            int len = this.interceptors.size();
            int pos = this.buffer.position();
            int lim = this.buffer.limit();
            for (i = 0; i < len; ++i) {
                this.buffer.flip();
                boolean shouldContinue = this.interceptors.get(i).onLogBuffer(this.buffer, this.level);
                if (!shouldContinue) {
                    aborted = true;
                }
                this.buffer.limit(lim).position(pos);
            }
        }
        if (!aborted) {
            this.buffer.put((byte)10);
            this.flushByteBuffer();
            if (Log.isBenchmark()) {
                Benchmarker.instance().measure();
            }
        } else {
            this.buffer.clear();
        }
    }

    private static final int indexOfPlaceholder(CharSequence cs, int start) {
        int len = cs.length();
        for (int i = start; i < len; ++i) {
            boolean hasTwoScapes;
            if (cs.charAt(i) != '{' || i + 1 >= len || cs.charAt(i + 1) != '}') continue;
            boolean hasOneScape = i - 1 >= 0 && cs.charAt(i - 1) == '\\';
            boolean bl = hasTwoScapes = i - 2 >= 0 && cs.charAt(i - 2) == '\\';
            if (hasOneScape && !hasTwoScapes) continue;
            return i;
        }
        return -1;
    }

    private static final void copySubstring(CharSequence cs, ByteBuffer bb, int start, int end, boolean fixEscape) {
        for (int i = start; i < end; ++i) {
            char currChar = cs.charAt(i);
            if (fixEscape && currChar == '\\' && i + 1 < end && cs.charAt(i + 1) == '\\' && i + 1 == end - 1 || currChar == '\\' && i + 1 < end && cs.charAt(i + 1) == '{' && i + 2 < end && cs.charAt(i + 2) == '}') continue;
            bb.put((byte)currChar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                return this.enabled;
            }
        }
        return this.enabled;
    }

    @Override
    public final Object[] getVarargs(int size) {
        switch (size) {
            case 1: {
                return this.oa1;
            }
            case 2: {
                return this.oa2;
            }
            case 3: {
                return this.oa3;
            }
            case 4: {
                return this.oa4;
            }
            case 5: {
                return this.oa5;
            }
            case 6: {
                return this.oa6;
            }
            case 7: {
                return this.oa7;
            }
            case 8: {
                return this.oa8;
            }
            case 9: {
                return this.oa9;
            }
            case 10: {
                return this.oa10;
            }
            case 11: {
                return this.oa11;
            }
            case 12: {
                return this.oa12;
            }
            case 13: {
                return this.oa13;
            }
            case 14: {
                return this.oa14;
            }
            case 15: {
                return this.oa15;
            }
            case 16: {
                return this.oa16;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa1[0] = s1;
                this.log(this.oa1);
            }
        } else {
            this.oa1[0] = s1;
            this.log(this.oa1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa2[0] = s1;
                this.oa2[1] = s2;
                this.log(this.oa2);
            }
        } else {
            this.oa2[0] = s1;
            this.oa2[1] = s2;
            this.log(this.oa2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa3[0] = s1;
                this.oa3[1] = s2;
                this.oa3[2] = s3;
                this.log(this.oa3);
            }
        } else {
            this.oa3[0] = s1;
            this.oa3[1] = s2;
            this.oa3[2] = s3;
            this.log(this.oa3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa4[0] = s1;
                this.oa4[1] = s2;
                this.oa4[2] = s3;
                this.oa4[3] = s4;
                this.log(this.oa4);
            }
        } else {
            this.oa4[0] = s1;
            this.oa4[1] = s2;
            this.oa4[2] = s3;
            this.oa4[3] = s4;
            this.log(this.oa4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa5[0] = s1;
                this.oa5[1] = s2;
                this.oa5[2] = s3;
                this.oa5[3] = s4;
                this.oa5[4] = s5;
                this.log(this.oa5);
            }
        } else {
            this.oa5[0] = s1;
            this.oa5[1] = s2;
            this.oa5[2] = s3;
            this.oa5[3] = s4;
            this.oa5[4] = s5;
            this.log(this.oa5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa6[0] = s1;
                this.oa6[1] = s2;
                this.oa6[2] = s3;
                this.oa6[3] = s4;
                this.oa6[4] = s5;
                this.oa6[5] = s6;
                this.log(this.oa6);
            }
        } else {
            this.oa6[0] = s1;
            this.oa6[1] = s2;
            this.oa6[2] = s3;
            this.oa6[3] = s4;
            this.oa6[4] = s5;
            this.oa6[5] = s6;
            this.log(this.oa6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa7[0] = s1;
                this.oa7[1] = s2;
                this.oa7[2] = s3;
                this.oa7[3] = s4;
                this.oa7[4] = s5;
                this.oa7[5] = s6;
                this.oa7[6] = s7;
                this.log(this.oa7);
            }
        } else {
            this.oa7[0] = s1;
            this.oa7[1] = s2;
            this.oa7[2] = s3;
            this.oa7[3] = s4;
            this.oa7[4] = s5;
            this.oa7[5] = s6;
            this.oa7[6] = s7;
            this.log(this.oa7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa8[0] = s1;
                this.oa8[1] = s2;
                this.oa8[2] = s3;
                this.oa8[3] = s4;
                this.oa8[4] = s5;
                this.oa8[5] = s6;
                this.oa8[6] = s7;
                this.oa8[7] = s8;
                this.log(this.oa8);
            }
        } else {
            this.oa8[0] = s1;
            this.oa8[1] = s2;
            this.oa8[2] = s3;
            this.oa8[3] = s4;
            this.oa8[4] = s5;
            this.oa8[5] = s6;
            this.oa8[6] = s7;
            this.oa8[7] = s8;
            this.log(this.oa8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa9[0] = s1;
                this.oa9[1] = s2;
                this.oa9[2] = s3;
                this.oa9[3] = s4;
                this.oa9[4] = s5;
                this.oa9[5] = s6;
                this.oa9[6] = s7;
                this.oa9[7] = s8;
                this.oa9[8] = s9;
                this.log(this.oa9);
            }
        } else {
            this.oa9[0] = s1;
            this.oa9[1] = s2;
            this.oa9[2] = s3;
            this.oa9[3] = s4;
            this.oa9[4] = s5;
            this.oa9[5] = s6;
            this.oa9[6] = s7;
            this.oa9[7] = s8;
            this.oa9[8] = s9;
            this.log(this.oa9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa10[0] = s1;
                this.oa10[1] = s2;
                this.oa10[2] = s3;
                this.oa10[3] = s4;
                this.oa10[4] = s5;
                this.oa10[5] = s6;
                this.oa10[6] = s7;
                this.oa10[7] = s8;
                this.oa10[8] = s9;
                this.oa10[9] = s10;
                this.log(this.oa10);
            }
        } else {
            this.oa10[0] = s1;
            this.oa10[1] = s2;
            this.oa10[2] = s3;
            this.oa10[3] = s4;
            this.oa10[4] = s5;
            this.oa10[5] = s6;
            this.oa10[6] = s7;
            this.oa10[7] = s8;
            this.oa10[8] = s9;
            this.oa10[9] = s10;
            this.log(this.oa10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa11[0] = s1;
                this.oa11[1] = s2;
                this.oa11[2] = s3;
                this.oa11[3] = s4;
                this.oa11[4] = s5;
                this.oa11[5] = s6;
                this.oa11[6] = s7;
                this.oa11[7] = s8;
                this.oa11[8] = s9;
                this.oa11[9] = s10;
                this.oa11[10] = s11;
                this.log(this.oa11);
            }
        } else {
            this.oa11[0] = s1;
            this.oa11[1] = s2;
            this.oa11[2] = s3;
            this.oa11[3] = s4;
            this.oa11[4] = s5;
            this.oa11[5] = s6;
            this.oa11[6] = s7;
            this.oa11[7] = s8;
            this.oa11[8] = s9;
            this.oa11[9] = s10;
            this.oa11[10] = s11;
            this.log(this.oa11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa12[0] = s1;
                this.oa12[1] = s2;
                this.oa12[2] = s3;
                this.oa12[3] = s4;
                this.oa12[4] = s5;
                this.oa12[5] = s6;
                this.oa12[6] = s7;
                this.oa12[7] = s8;
                this.oa12[8] = s9;
                this.oa12[9] = s10;
                this.oa12[10] = s11;
                this.oa12[11] = s12;
                this.log(this.oa12);
            }
        } else {
            this.oa12[0] = s1;
            this.oa12[1] = s2;
            this.oa12[2] = s3;
            this.oa12[3] = s4;
            this.oa12[4] = s5;
            this.oa12[5] = s6;
            this.oa12[6] = s7;
            this.oa12[7] = s8;
            this.oa12[8] = s9;
            this.oa12[9] = s10;
            this.oa12[10] = s11;
            this.oa12[11] = s12;
            this.log(this.oa12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa13[0] = s1;
                this.oa13[1] = s2;
                this.oa13[2] = s3;
                this.oa13[3] = s4;
                this.oa13[4] = s5;
                this.oa13[5] = s6;
                this.oa13[6] = s7;
                this.oa13[7] = s8;
                this.oa13[8] = s9;
                this.oa13[9] = s10;
                this.oa13[10] = s11;
                this.oa13[11] = s12;
                this.oa13[12] = s13;
                this.log(this.oa13);
            }
        } else {
            this.oa13[0] = s1;
            this.oa13[1] = s2;
            this.oa13[2] = s3;
            this.oa13[3] = s4;
            this.oa13[4] = s5;
            this.oa13[5] = s6;
            this.oa13[6] = s7;
            this.oa13[7] = s8;
            this.oa13[8] = s9;
            this.oa13[9] = s10;
            this.oa13[10] = s11;
            this.oa13[11] = s12;
            this.oa13[12] = s13;
            this.log(this.oa13);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13, Object s14) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa14[0] = s1;
                this.oa14[1] = s2;
                this.oa14[2] = s3;
                this.oa14[3] = s4;
                this.oa14[4] = s5;
                this.oa14[5] = s6;
                this.oa14[6] = s7;
                this.oa14[7] = s8;
                this.oa14[8] = s9;
                this.oa14[9] = s10;
                this.oa14[10] = s11;
                this.oa14[11] = s12;
                this.oa14[12] = s13;
                this.oa14[13] = s14;
                this.log(this.oa14);
            }
        } else {
            this.oa14[0] = s1;
            this.oa14[1] = s2;
            this.oa14[2] = s3;
            this.oa14[3] = s4;
            this.oa14[4] = s5;
            this.oa14[5] = s6;
            this.oa14[6] = s7;
            this.oa14[7] = s8;
            this.oa14[8] = s9;
            this.oa14[9] = s10;
            this.oa14[10] = s11;
            this.oa14[11] = s12;
            this.oa14[12] = s13;
            this.oa14[13] = s14;
            this.log(this.oa14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13, Object s14, Object s15) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa15[0] = s1;
                this.oa15[1] = s2;
                this.oa15[2] = s3;
                this.oa15[3] = s4;
                this.oa15[4] = s5;
                this.oa15[5] = s6;
                this.oa15[6] = s7;
                this.oa15[7] = s8;
                this.oa15[8] = s9;
                this.oa15[9] = s10;
                this.oa15[10] = s11;
                this.oa15[11] = s12;
                this.oa15[12] = s13;
                this.oa15[13] = s14;
                this.oa15[14] = s15;
                this.log(this.oa15);
            }
        } else {
            this.oa15[0] = s1;
            this.oa15[1] = s2;
            this.oa15[2] = s3;
            this.oa15[3] = s4;
            this.oa15[4] = s5;
            this.oa15[5] = s6;
            this.oa15[6] = s7;
            this.oa15[7] = s8;
            this.oa15[8] = s9;
            this.oa15[9] = s10;
            this.oa15[10] = s11;
            this.oa15[11] = s12;
            this.oa15[12] = s13;
            this.oa15[13] = s14;
            this.oa15[14] = s15;
            this.log(this.oa15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Object s1, Object s2, Object s3, Object s4, Object s5, Object s6, Object s7, Object s8, Object s9, Object s10, Object s11, Object s12, Object s13, Object s14, Object s15, Object s16) {
        if (this.isSynchronized) {
            DefaultLogger defaultLogger = this;
            synchronized (defaultLogger) {
                this.oa16[0] = s1;
                this.oa16[1] = s2;
                this.oa16[2] = s3;
                this.oa16[3] = s4;
                this.oa16[4] = s5;
                this.oa16[5] = s6;
                this.oa16[6] = s7;
                this.oa16[7] = s8;
                this.oa16[8] = s9;
                this.oa16[9] = s10;
                this.oa16[10] = s11;
                this.oa16[11] = s12;
                this.oa16[12] = s13;
                this.oa16[13] = s14;
                this.oa16[14] = s15;
                this.oa16[15] = s16;
                this.log(this.oa16);
            }
        } else {
            this.oa16[0] = s1;
            this.oa16[1] = s2;
            this.oa16[2] = s3;
            this.oa16[3] = s4;
            this.oa16[4] = s5;
            this.oa16[5] = s6;
            this.oa16[6] = s7;
            this.oa16[7] = s8;
            this.oa16[8] = s9;
            this.oa16[9] = s10;
            this.oa16[10] = s11;
            this.oa16[11] = s12;
            this.oa16[12] = s13;
            this.oa16[13] = s14;
            this.oa16[14] = s15;
            this.oa16[15] = s16;
            this.log(this.oa16);
        }
    }

    private final LogEvent getLogEvent() {
        if (!this.isAsynchronous) {
            return LogEventUtils.getLogEvent();
        }
        return AsyncThread.getLogEvent(this);
    }

    @Override
    public LogMessageBuilder add(char[] x) {
        if (!this.isAsynchronous) {
            this.getLogEvent().add(x);
        } else {
            this.getLogEvent().addCopy(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(byte[] x) {
        if (!this.isAsynchronous) {
            this.getLogEvent().add(x);
        } else {
            this.getLogEvent().addCopy(x);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(long x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(int x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(double x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(float x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(byte x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(short x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(char x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(boolean x) {
        this.getLogEvent().add(x);
        return this;
    }

    @Override
    public LogMessageBuilder add(Object o) {
        this.getLogEvent().add(o);
        return this;
    }

    @Override
    public LogMessageBuilder add(StringBuilder sb) {
        if (!this.isAsynchronous) {
            this.getLogEvent().add(sb);
        } else {
            this.getLogEvent().addCopy(sb);
        }
        return this;
    }

    @Override
    public LogMessageBuilder add(AsciiEncodable cs) {
        if (!this.isAsynchronous) {
            this.getLogEvent().add(cs);
        } else {
            this.getLogEvent().addCopy(cs);
        }
        return this;
    }

    @Override
    public void flush() {
        LogEvent logEvent = this.getLogEvent();
        logEvent.setLogger(this);
        if (!this.isAsynchronous) {
            logEvent.log();
        } else {
            AsyncThread.offer(logEvent);
        }
    }
}

