/*
 * Decompiled with CFR 0.152.
 */
package org.mentaaffinity;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.mentaaffinity.AffinityException;

public class Processor {
    private static final Map<Thread, Processor> threadToProcessor = Collections.synchronizedMap(new IdentityHashMap());
    private final int procId;
    private final int chipId;
    private final int coreId;
    private final boolean isExcluded;
    private boolean isAssigned = false;
    private boolean leaveIdle = false;
    private Thread thread = null;
    private final String name;

    public Processor(int procId, int chipId, int coreId, boolean isExcluded) {
        this.procId = procId;
        this.chipId = chipId;
        this.coreId = coreId;
        this.isExcluded = isExcluded;
        this.name = "Processor-" + procId;
    }

    public synchronized String getStatusString() {
        if (this.isExcluded) {
            return "reserved for the OS";
        }
        if (this.leaveIdle) {
            return "left idle by " + this.thread.getName();
        }
        if (this.isAssigned) {
            if (this.thread.isAlive()) {
                return "bound to " + this.thread.getName() + " (running)";
            }
            return "assigned to " + this.thread.getName() + " (not-started)";
        }
        return "free";
    }

    public int getId() {
        return this.procId;
    }

    public int getChipId() {
        return this.chipId;
    }

    public int getCoreId() {
        return this.coreId;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public synchronized boolean isFree() {
        return !this.isAssigned && !this.isExcluded && !this.leaveIdle;
    }

    public synchronized boolean isAssigned() {
        return this.isAssigned;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    synchronized void assign(Thread thread) {
        Processor previousProc = threadToProcessor.get(thread);
        if (previousProc != null && !thread.isAlive()) {
            previousProc.unassign(thread);
        } else {
            if (this.isAssigned) {
                throw new AffinityException("Processor is already assigned to a thread: " + this.thread);
            }
            if (threadToProcessor.containsKey(thread)) {
                throw new AffinityException("Thread is already assigned to a processor!");
            }
        }
        this.isAssigned = true;
        this.thread = thread;
        threadToProcessor.put(thread, this);
    }

    synchronized void setIdle(Thread thread, boolean flag) {
        if (!flag) {
            if (this.thread != thread) {
                throw new AffinityException("Processor was not made idle by this thread: " + this.thread);
            }
            this.leaveIdle = false;
            this.thread = null;
        } else {
            if (this.leaveIdle) {
                throw new AffinityException("Processor is already idle: " + this.thread);
            }
            this.leaveIdle = true;
            this.thread = thread;
        }
    }

    synchronized void unassign(Thread thread) {
        if (this.thread != thread) {
            throw new AffinityException("Processor is assigned to another thread: " + this.thread);
        }
        if (!threadToProcessor.containsKey(thread)) {
            throw new AffinityException("Thread is not assigned to any processor!");
        }
        this.isAssigned = false;
        this.thread = null;
        threadToProcessor.remove(thread);
    }

    public boolean sameChip(Processor other) {
        return other.chipId == this.chipId;
    }

    public boolean sameCore(Processor other) {
        return this.sameChip(other) && other.coreId == this.coreId;
    }

    public boolean sameChipDifferentCore(Processor other) {
        return this.sameChip(other) && other.coreId != this.coreId;
    }

    public int hashCode() {
        return this.procId;
    }

    static Processor getAssignedProcessorForThread(Thread t) {
        return threadToProcessor.get(t);
    }

    public boolean equals(Object o) {
        if (o instanceof Processor) {
            Processor lp = (Processor)o;
            return lp.procId == this.procId;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public int getMask() {
        return 1 << this.procId;
    }
}

