/*
 * Decompiled with CFR 0.152.
 */
package org.mentaaffinity;

import java.io.File;
import java.util.List;
import org.mentaaffinity.AffinityException;
import org.mentaaffinity.Chip;
import org.mentaaffinity.Core;
import org.mentaaffinity.CpuInfo;
import org.mentaaffinity.Processor;
import org.mentaaffinity.ThreadAffinity;
import org.mentalog.Log;

public class Affinity {
    private static boolean enabled = true;
    private static Boolean available = null;

    private static Chip getSingleChip() {
        List<Chip> chips = CpuInfo.getChips();
        if (chips.size() != 1) {
            throw new AffinityException("Your computer has more than one chip so you must specify the chip you want to use when assigning threads!");
        }
        return chips.get(0);
    }

    private static Chip getChip(int id) {
        for (int i = 0; i < CpuInfo.getChips().size(); ++i) {
            Chip c = CpuInfo.getChips().get(i);
            if (c.getId() != id) continue;
            return c;
        }
        throw new AffinityException("Cannot find chip for id: " + id);
    }

    public static void setEnable(boolean flag) {
        enabled = flag;
    }

    private static synchronized Processor getProcessor(int id) {
        List<Chip> chips = CpuInfo.getChips();
        for (int i = 0; i < chips.size(); ++i) {
            List<Core> cores = chips.get(i).getCores();
            for (int j = 0; j < cores.size(); ++j) {
                List<Processor> procs = cores.get(j).getProcessors();
                for (int k = 0; k < procs.size(); ++k) {
                    if (procs.get(k).getId() != id) continue;
                    return procs.get(k);
                }
            }
        }
        return null;
    }

    public static final boolean isAvailable() {
        if (available == null) {
            try {
                Class.forName("com.sun.jna.Platform");
            }
            catch (Exception ignored) {
                Log.Debug.log((Object)"MentaAffinity", (Object)"Cannot load JNA! Make sure to install from https://github.com/twall/jna. You may have to include the jna.jar in the classpath.");
                available = false;
                return false;
            }
            File file = new File("/proc/cpuinfo");
            if (!file.exists()) {
                Log.Debug.log((Object)"MentaAffinity", (Object)"Cannot find file:", (Object)"/proc/cpuinfo");
                available = false;
                return false;
            }
            available = true;
        }
        return available;
    }

    public static void init() {
        CpuInfo.init();
    }

    public static synchronized void assignToProcessor(int procId, Thread t) {
        Processor p = Affinity.getProcessor(procId);
        if (p == null) {
            throw new AffinityException("Cannot find processor: " + procId);
        }
        p.assign(t);
    }

    public static synchronized Processor assignToAnyFreeProcessor(Thread t) {
        return Affinity.assignToAnyFreeProcessor(Affinity.getSingleChip().getId(), t);
    }

    public static synchronized Processor assignToAnyFreeProcessor(int chipId, Thread t) {
        Chip chip = Affinity.getChip(chipId);
        Core core = chip.getFreeCore();
        if (core == null) {
            throw new AffinityException("Cannot find a free core from chip: " + chip);
        }
        Processor processor = core.getFreeProcessor();
        processor.assign(t);
        return processor;
    }

    public static synchronized Core assignToAnyFreeCore(Thread t) {
        return Affinity.assignToAnyFreeCore(Affinity.getSingleChip().getId(), t);
    }

    public static synchronized Core assignToAnyFreeCore(int chipId, Thread t) {
        Chip chip = Affinity.getChip(chipId);
        Core core = chip.getFullyFreeCore();
        if (core == null) {
            throw new AffinityException("Cannot find a fully free core from chip: " + chip);
        }
        core.assign(t);
        return core;
    }

    public static synchronized void assignToSameCore(Thread t1, Thread t2) {
        Affinity.assignToSameCore(Affinity.getSingleChip().getId(), t1, t2);
    }

    public static synchronized void assignToSameCore(int chipId, Thread t1, Thread t2) {
        Chip chip = Affinity.getChip(chipId);
        Core core = chip.getFullyFreeCore();
        if (core == null) {
            throw new AffinityException("Cannot find a fully free core from chip: " + chip);
        }
        core.assign(t1, t2);
    }

    public static synchronized void assignToDifferentCores(Thread t1, Thread t2) {
        Affinity.assignToDifferentCores(Affinity.getSingleChip().getId(), t1, t2);
    }

    public static synchronized void assignToDifferentCores(int chipId, Thread t1, Thread t2) {
        Chip chip = Affinity.getChip(chipId);
        if (chip.getNumberOfFreeCores() < 2) {
            throw new AffinityException("There are no two free cores in this chip: " + chip);
        }
        Core core1 = chip.getFreeCore();
        core1.assign(t1);
        Core core2 = chip.getFreeCore();
        core2.assign(t2);
    }

    public static synchronized void assignToDifferentChips(Thread t1, Thread t2) {
        List<Chip> chips = CpuInfo.getChips();
        if (chips.size() == 1) {
            throw new AffinityException("Your computer only have one chip!");
        }
        if (chips.size() > 2) {
            throw new AffinityException("Your computer has more than one chip so you must specify the chip you want to use when assigning threads!");
        }
        Affinity.assignToDifferentChips(chips.get(0).getId(), t1, chips.get(1).getId(), t2);
    }

    public static synchronized void assignToDifferentChips(int chipId1, Thread t1, int chipId2, Thread t2) {
        Chip chip1 = Affinity.getChip(chipId1);
        Chip chip2 = Affinity.getChip(chipId2);
        if (!chip1.hasFreeCore()) {
            throw new AffinityException("This chip does not have a free core: " + chip1);
        }
        if (!chip2.hasFreeCore()) {
            throw new AffinityException("This chip does not have a free core: " + chip2);
        }
        chip1.getFreeCore().getFreeProcessor().assign(t1);
        chip2.getFreeCore().getFreeProcessor().assign(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void bind() {
        if (!enabled || !Affinity.isAvailable()) {
            return;
        }
        Class<Affinity> clazz = Affinity.class;
        synchronized (Affinity.class) {
            Thread t = Thread.currentThread();
            Core core = Core.getAssignedCoreForThread(t);
            if (core != null) {
                for (int i = 0; i < core.getProcessors().size(); ++i) {
                    Processor p = core.getProcessors().get(i);
                    if (!p.isAssigned()) continue;
                    if (p.getThread() != t) {
                        throw new AffinityException("Cannot bind to this processor: " + p.getThread().getName());
                    }
                    try {
                        ThreadAffinity.setCurrentThreadAffinityMask(p.getMask());
                        if (Log.Debug.isEnabled()) {
                            Log.Debug.log((Object)"MentaAffinity", (Object)"Thread bound to core:", (Object)"thread=", (Object)p.getThread().getName(), (Object)"core=", (Object)core, (Object)"proc=", (Object)p);
                        }
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    catch (Exception e) {
                        throw new AffinityException("Cannot bind with native code!", e);
                    }
                }
                throw new AffinityException("Error binding to core: " + core);
            }
            Processor processor = Processor.getAssignedProcessorForThread(t);
            if (processor != null) {
                if (processor.isAssigned()) {
                    if (processor.getThread() != t) {
                        throw new AffinityException("Cannot bind to this processor: " + processor.getThread().getName());
                    }
                    try {
                        ThreadAffinity.setCurrentThreadAffinityMask(processor.getMask());
                        if (Log.Debug.isEnabled()) {
                            Log.Debug.log((Object)"MentaAffinity", (Object)"Thread bound to processor:", (Object)"thread=", (Object)processor.getThread().getName(), (Object)"proc=", (Object)processor);
                        }
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    catch (Exception e) {
                        throw new AffinityException("Cannot bind with native code!", e);
                    }
                }
                throw new AffinityException("Error binding to processor: " + processor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unbind() {
        if (!enabled || !Affinity.isAvailable()) {
            return;
        }
        Class<Affinity> clazz = Affinity.class;
        synchronized (Affinity.class) {
            Thread t = Thread.currentThread();
            Core core = Core.getAssignedCoreForThread(t);
            if (core != null) {
                core.unassign(t);
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Processor processor = Processor.getAssignedProcessorForThread(t);
            if (processor != null) {
                processor.unassign(t);
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void printSituation() {
        List<Chip> chips = CpuInfo.getChips();
        for (int i = 0; i < chips.size(); ++i) {
            Chip chip = chips.get(i);
            chip.printSituation();
        }
    }

    public static void main(String[] args) {
        System.out.println("JPA available: " + Affinity.isAvailable());
        System.out.println();
        System.out.println("Processors:");
        System.out.println();
        Affinity.printSituation();
    }

    static {
        if (Affinity.isAvailable()) {
            Affinity.init();
            Log.Debug.log((Object)"MentaAffinity loaded!", (Object)CpuInfo.instance().toString());
        }
    }
}

