/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.wait;

import java.util.concurrent.locks.LockSupport;
import org.mentaqueue.wait.WaitStrategy;

public class SpinYieldParkWaitStrategy
implements WaitStrategy {
    private static final int DEFAULT_SPIN_COUNT = 100;
    private static final int DEFAULT_YIELD_COUNT = 100;
    private static final boolean DEFAULT_BACK_OFF = false;
    private final int spinCount;
    private final int yieldCount;
    private final boolean parkBackOff;
    private int count = 0;
    private int sleepTime = 0;

    public SpinYieldParkWaitStrategy(int spinCount, int yieldCount, boolean parkBackOff) {
        this.spinCount = spinCount;
        this.yieldCount = yieldCount + spinCount;
        this.parkBackOff = parkBackOff;
    }

    public SpinYieldParkWaitStrategy(boolean parkBackOff) {
        this(100, 100, parkBackOff);
    }

    public SpinYieldParkWaitStrategy(int spinCount, int yieldCount) {
        this(spinCount, yieldCount, false);
    }

    public SpinYieldParkWaitStrategy() {
        this(100, 100, false);
    }

    @Override
    public final void waitForOtherThread() {
        if (this.count < this.spinCount) {
            ++this.count;
        } else if (this.count < this.yieldCount) {
            Thread.yield();
            ++this.count;
        } else if (this.parkBackOff) {
            LockSupport.parkNanos(++this.sleepTime);
        } else {
            LockSupport.parkNanos(1L);
        }
    }

    @Override
    public final void reset() {
        this.count = 0;
        this.sleepTime = 0;
    }
}

