/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.wait;

import java.util.concurrent.locks.LockSupport;
import org.mentaqueue.wait.WaitStrategy;

public class ParkWaitStrategy
implements WaitStrategy {
    private static final boolean DEFAULT_BACK_OFF = false;
    private final boolean parkBackOff;
    private int sleepTime = 0;

    public ParkWaitStrategy(boolean parkBackOff) {
        this.parkBackOff = parkBackOff;
    }

    public ParkWaitStrategy() {
        this(false);
    }

    @Override
    public final void waitForOtherThread() {
        if (this.parkBackOff) {
            LockSupport.parkNanos(++this.sleepTime);
        } else {
            LockSupport.parkNanos(1L);
        }
    }

    @Override
    public final void reset() {
        this.sleepTime = 0;
    }
}

