/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.producer;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.mentaqueue.AtomicQueue;
import org.mentaqueue.BlockingArrayQueue;
import org.mentaqueue.BlockingLinkedQueue;
import org.mentaqueue.BlockingQueue;
import org.mentaqueue.BrokenFastQueue;
import org.mentaqueue.ConcurrentLinkedQueue;
import org.mentaqueue.LockedQueue;
import org.mentaqueue.SynchronizedQueue;
import org.mentaqueue.VolatileQueue;
import org.mentaqueue.pooled.PooledBlockingArrayQueue;
import org.mentaqueue.pooled.PooledBlockingLinkedQueue;
import org.mentaqueue.pooled.PooledBlockingQueue;
import org.mentaqueue.pooled.PooledConcurrentLinkedQueue;
import org.mentaqueue.test.producer.TestAtomicQueue;
import org.mentaqueue.test.producer.TestBlockingArrayQueue;
import org.mentaqueue.test.producer.TestBlockingLinkedQueue;
import org.mentaqueue.test.producer.TestBlockingQueue;
import org.mentaqueue.test.producer.TestBrokenFastQueue;
import org.mentaqueue.test.producer.TestConcurrentLinkedQueue;
import org.mentaqueue.test.producer.TestLockedQueue;
import org.mentaqueue.test.producer.TestPooledBlockingArrayQueue;
import org.mentaqueue.test.producer.TestPooledBlockingLinkedQueue;
import org.mentaqueue.test.producer.TestPooledBlockingQueue;
import org.mentaqueue.test.producer.TestPooledConcurrentLinkedQueue;
import org.mentaqueue.test.producer.TestSynchronizedQueue;
import org.mentaqueue.test.producer.TestVolatileQueue;

public class TestAll {
    private static final Map<Long, String> results = new TreeMap<Long, String>();
    private static final NumberFormat NUMBER_FORMATTER = new DecimalFormat("#,###,###");

    private static final void addResult(long value, String res) {
        while (results.containsKey(value)) {
            --value;
        }
        results.put(value, res);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.out.println("format: java -Xms1g -Xmx4g -XX:NewSize=512m -XX:MaxNewSize=1024m -DtestNonBatchingQueues=true -cp target/classes org.mentaqueue.test.producer.TestAll IGNORE OUTLIERS RUNS MESSAGES BUFFER_SIZE");
            System.out.println("IGNORE => How many initial runs will be ignored when calculating the average (warmup runs)?");
            System.out.println("OUTLIERS => How many best and worst to remove?");
            System.out.println("RUNS => How many times to run the test?");
            System.out.println("MESSAGES => How many messages to send to the other thread? (in thousands)");
            System.out.println("BUFFER_SIZE => How many messages can the buffer hold? (in multiples of 1024)");
            System.out.println();
            return;
        }
        String[] params = new String[6];
        for (int i = 0; i < args.length; ++i) {
            params[i] = args[i];
        }
        params[5] = "true";
        String s = System.getProperty("testNonBatchingQueues");
        boolean testNonBatching = false;
        if (s != null && s.equals("true")) {
            testNonBatching = true;
        }
        for (int i = 0; i < 2; ++i) {
            if (i == 1) {
                if (!testNonBatching) break;
                System.out.println();
                System.out.println("Now testing queues on non-batching mode:");
                System.out.println();
            }
            String suffix = "";
            if (i == 1 && testNonBatching) {
                suffix = " (*)";
                params[5] = "false";
            }
            if (i == 0) {
                TestBrokenFastQueue.main(params);
                TestAll.addResult(TestBrokenFastQueue.getResult(), BrokenFastQueue.class.getSimpleName() + suffix);
            }
            TestAtomicQueue.main(params);
            TestAll.addResult(TestAtomicQueue.getResult(), AtomicQueue.class.getSimpleName() + suffix);
            TestVolatileQueue.main(params);
            TestAll.addResult(TestVolatileQueue.getResult(), VolatileQueue.class.getSimpleName() + suffix);
            TestLockedQueue.main(params);
            TestAll.addResult(TestLockedQueue.getResult(), LockedQueue.class.getSimpleName() + suffix);
            TestSynchronizedQueue.main(params);
            TestAll.addResult(TestSynchronizedQueue.getResult(), SynchronizedQueue.class.getSimpleName() + suffix);
            if (i == 0) {
                TestPooledConcurrentLinkedQueue.main(params);
                TestAll.addResult(TestPooledConcurrentLinkedQueue.getResult(), PooledConcurrentLinkedQueue.class.getSimpleName() + suffix);
                TestConcurrentLinkedQueue.main(params);
                TestAll.addResult(TestConcurrentLinkedQueue.getResult(), ConcurrentLinkedQueue.class.getSimpleName() + suffix);
            }
            TestPooledBlockingArrayQueue.main(params);
            TestAll.addResult(TestPooledBlockingArrayQueue.getResult(), PooledBlockingArrayQueue.class.getSimpleName() + suffix);
            TestPooledBlockingLinkedQueue.main(params);
            TestAll.addResult(TestPooledBlockingLinkedQueue.getResult(), PooledBlockingLinkedQueue.class.getSimpleName() + suffix);
            TestBlockingLinkedQueue.main(params);
            TestAll.addResult(TestBlockingLinkedQueue.getResult(), BlockingLinkedQueue.class.getSimpleName() + suffix);
            TestBlockingArrayQueue.main(params);
            TestAll.addResult(TestBlockingArrayQueue.getResult(), BlockingArrayQueue.class.getSimpleName() + suffix);
            TestBlockingQueue.main(params);
            TestAll.addResult(TestBlockingQueue.getResult(), BlockingQueue.class.getSimpleName() + suffix);
            TestPooledBlockingQueue.main(params);
            TestAll.addResult(TestPooledBlockingQueue.getResult(), PooledBlockingQueue.class.getSimpleName() + suffix);
        }
        System.out.println();
        System.out.println("Final results:\n");
        Iterator<Long> iter = results.keySet().iterator();
        int count = 1;
        long champion = 0L;
        while (iter.hasNext()) {
            long nanosPerMsg = iter.next();
            String queue = results.get(nanosPerMsg);
            String res = count + ": " + queue + " => " + NUMBER_FORMATTER.format(nanosPerMsg) + " nanoseconds/message";
            if (count == 2) {
                champion = nanosPerMsg;
            } else if (count > 2) {
                res = res + " (" + TestAll.roundTwoDecimals(nanosPerMsg, champion) + "x)";
            }
            System.out.println(res);
            ++count;
        }
        System.out.println();
        if (testNonBatching) {
            System.out.println("(*) => Non-batching mode");
            System.out.println();
        }
        System.out.println("Test details:");
        System.out.println();
        System.out.println("Warmup iterations per queue: " + args[0]);
        System.out.println("Outliers ignored (worst and best): " + Integer.parseInt(args[1]) * 2);
        int considered = Integer.parseInt(args[2]) - (Integer.parseInt(args[0]) + Integer.parseInt(args[1]) * 2);
        System.out.println("Total number of iterations: " + args[2] + " (considered: " + considered + ")");
        System.out.println("Total number of messages sent to the other thread: " + NUMBER_FORMATTER.format(Integer.parseInt(args[3]) * 1000));
        System.out.println("Queue buffer size: " + NUMBER_FORMATTER.format(Integer.parseInt(args[4]) * 1024));
        System.out.println("Also test non-batching queues: " + testNonBatching);
        System.out.println();
    }

    private static String roundTwoDecimals(long x, long y) {
        float f = (float)x / (float)y;
        f *= 100.0f;
        f = Math.round(f);
        return String.valueOf(f /= 100.0f);
    }
}

