/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.test.messages;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mentaqueue.pooled.PooledBlockingLinkedQueue;
import org.mentaqueue.util.MutableLong;
import org.mentaqueue.wait.ParkWaitStrategy;

public class TestPooledBlockingLinkedQueue {
    private static final boolean PRINT_RUNS = false;
    private static final NumberFormat NUMBER_FORMATTER = new DecimalFormat("#,###,###");
    private static long START_TIME;
    private static List<Long> RESULTS;
    private static long opsPerSec;

    public static void main(String[] args) throws Exception {
        int i;
        if (args.length != 6) {
            System.out.println("format: java -Xms1g -Xmx4g -XX:NewSize=512m -XX:MaxNewSize=1024m -cp target/classes org.mentaqueue.test.messages.TestPooledBlockingLinkedQueue IGNORE OUTLIERS RUNS MESSAGES BUFFER_SIZE NON_BATCHING");
            System.out.println("IGNORE => How many initial runs will be ignored when calculating the average (warmup runs)?");
            System.out.println("OUTLIERS => How many best and worst to remove?");
            System.out.println("RUNS => How many times to run the test?");
            System.out.println("MESSAGES => How many messages to send to the other thread? (in thousands)");
            System.out.println("BUFFER_SIZE => How many messages can the buffer hold? (in multiples of 1024)");
            System.out.println("BATCHING => You can pass false here if you want to test the impact of batching. (Non-batching must be worse!)");
            System.out.println();
            return;
        }
        final ParkWaitStrategy consumerWaitStrategy = new ParkWaitStrategy();
        ParkWaitStrategy producerWaitStrategy = new ParkWaitStrategy(true);
        int ignore = Integer.parseInt(args[0]);
        int outliers = Integer.parseInt(args[1]);
        int runs = Integer.parseInt(args[2]);
        final long messages = Long.parseLong(args[3]) * 1000L;
        int bufferSize = Integer.parseInt(args[4]) * 1024;
        final boolean batching = Boolean.parseBoolean(args[5]);
        int totalIterations = runs - ignore - 2 * outliers;
        if (totalIterations <= 0) {
            System.out.println("Please increase the number of RUNS!");
            return;
        }
        System.out.print(TestPooledBlockingLinkedQueue.class.getSimpleName());
        RESULTS = new ArrayList<Long>(runs);
        for (int z = 0; z < runs; ++z) {
            System.gc();
            Thread.sleep(100L);
            final PooledBlockingLinkedQueue<MutableLong> queue = new PooledBlockingLinkedQueue<MutableLong>(bufferSize, MutableLong.BUILDER);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long count = 0L;
                    while (count < messages) {
                        long avail = queue.available();
                        if (avail > 0L) {
                            if (!batching) {
                                avail = 1L;
                            }
                            int x = 0;
                            while ((long)x < avail) {
                                MutableLong ml = (MutableLong)queue.poll();
                                if (ml != null) {
                                    if (ml.get() != count) {
                                        throw new IllegalStateException("This should never happen: expectedSeq=" + count + " receivedSeq=" + ml.get());
                                    }
                                    ++count;
                                } else {
                                    throw new IllegalStateException("This should never happen!");
                                }
                                ++x;
                            }
                            consumerWaitStrategy.reset();
                            queue.done();
                            continue;
                        }
                        consumerWaitStrategy.waitForOtherThread();
                    }
                    long totalTime = System.currentTimeMillis() - START_TIME;
                    long opsPerSecond = messages * 1000L / (totalTime + 1L);
                    RESULTS.add(opsPerSecond);
                    System.out.print('.');
                }
            }, "Consumer");
            t.start();
            START_TIME = System.currentTimeMillis();
            int i2 = 0;
            while ((long)i2 < messages) {
                MutableLong ml = queue.nextToOffer();
                if (ml == null) {
                    producerWaitStrategy.waitForOtherThread();
                    --i2;
                } else {
                    ml.set(i2);
                    queue.offer(ml);
                    producerWaitStrategy.reset();
                }
                ++i2;
            }
            t.join();
        }
        System.out.println(" DONE");
        int originalTotal = RESULTS.size();
        List<Long> list = TestPooledBlockingLinkedQueue.removeWarmUp(RESULTS, ignore);
        for (i = 0; i < outliers; ++i) {
            TestPooledBlockingLinkedQueue.removeMin(list);
        }
        for (i = 0; i < outliers; ++i) {
            TestPooledBlockingLinkedQueue.removeMax(list);
        }
        long totalTime = TestPooledBlockingLinkedQueue.addValues(list);
        opsPerSec = totalTime / (long)list.size();
        System.out.println("Average: " + NUMBER_FORMATTER.format(opsPerSec) + " ops/sec (sample_size=" + originalTotal + ", warmup=" + ignore + ", outliers=" + outliers * 2 + ", runs_considered = " + list.size() + ")");
    }

    public static long getResult() {
        return opsPerSec;
    }

    private static long addValues(List<Long> list) {
        long total = 0L;
        for (long l : list) {
            total += l;
        }
        return total;
    }

    private static List<Long> removeWarmUp(List<Long> list, int ignored) {
        Iterator<Long> iter = list.iterator();
        for (int i = 0; i < ignored; ++i) {
            if (!iter.hasNext()) continue;
            iter.next();
            iter.remove();
        }
        return list;
    }

    private static void removeMax(List<Long> list) {
        int max = 0;
        for (int i = 0; i < list.size(); ++i) {
            long currMax = list.get(max);
            long currValue = list.get(i);
            if (currValue <= currMax) continue;
            max = i;
        }
        list.remove(max);
    }

    private static void removeMin(List<Long> list) {
        int min = 0;
        for (int i = 0; i < list.size(); ++i) {
            long currMin = list.get(min);
            long currValue = list.get(i);
            if (currValue >= currMin) continue;
            min = i;
        }
        list.remove(min);
    }
}

