/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.pooled;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.mentaqueue.Queue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class PooledConcurrentLinkedQueue<E>
implements Queue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final ConcurrentLinkedQueue<E> pool = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue();
    private final Builder<E> builder;
    private E returnedElem = null;

    public PooledConcurrentLinkedQueue(int capacity, Builder<E> builder) {
        this.builder = builder;
        for (int i = 0; i < capacity; ++i) {
            this.pool.offer(builder.newInstance());
        }
    }

    public PooledConcurrentLinkedQueue(Builder<E> builder) {
        this(16416, builder);
    }

    public PooledConcurrentLinkedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public PooledConcurrentLinkedQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToOffer() {
        E e = this.pool.poll();
        if (e == null) {
            e = this.builder.newInstance();
        }
        return e;
    }

    @Override
    public void offer(E e) {
        this.queue.offer(e);
    }

    @Override
    public long available() {
        E e = this.queue.peek();
        return e != null ? 1L : 0L;
    }

    @Override
    public E poll() {
        this.returnedElem = this.queue.poll();
        return this.returnedElem;
    }

    @Override
    public void done() {
        this.pool.offer(this.returnedElem);
        this.returnedElem = null;
    }
}

