/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue.pooled;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.mentaqueue.Queue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class PooledBlockingLinkedQueue<E>
implements Queue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final ConcurrentLinkedQueue<E> pool = new ConcurrentLinkedQueue();
    private final List<E> polledElements = new LinkedList();
    private final LinkedBlockingQueue<E> queue;
    private final Builder<E> builder;

    public PooledBlockingLinkedQueue(int capacity, Builder<E> builder) {
        this.queue = new LinkedBlockingQueue(capacity);
        this.builder = builder;
        for (int i = 0; i < capacity; ++i) {
            this.pool.offer(builder.newInstance());
        }
    }

    public PooledBlockingLinkedQueue(Builder<E> builder) {
        this(16416, builder);
    }

    public PooledBlockingLinkedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public PooledBlockingLinkedQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToOffer() {
        E e = this.pool.poll();
        if (e == null) {
            e = this.builder.newInstance();
        }
        return e;
    }

    @Override
    public void offer(E e) {
        try {
            this.queue.put(e);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public long available() {
        return this.queue.size();
    }

    @Override
    public E poll() {
        E returnedElem = this.queue.poll();
        this.polledElements.add(returnedElem);
        return returnedElem;
    }

    @Override
    public void done() {
        Iterator<E> iter = this.polledElements.iterator();
        while (iter.hasNext()) {
            this.pool.offer(iter.next());
            iter.remove();
        }
    }
}

