/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mentaqueue.Queue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;
import org.mentaqueue.util.NumberUtils;

public class LockedQueue<E>
implements Queue<E> {
    private static final int DEFAULT_CAPACITY = 16384;
    private final int capacity;
    private final E[] data;
    private long nextOfferValue = -1L;
    private long nextPollValue = -1L;
    private long offeringSequence = -1L;
    private long pollingSequence = -1L;
    private final Lock offeringLock = new ReentrantLock();
    private final Lock pollingLock = new ReentrantLock();
    private long maxSeq;

    public LockedQueue(int capacity, Builder<E> builder) {
        NumberUtils.ensurePowerOfTwo(capacity);
        this.capacity = capacity;
        this.data = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.data[i] = builder.newInstance();
        }
        this.maxSeq = this.findMaxSeqBeforeWrapping();
    }

    public LockedQueue(Builder<E> builder) {
        this(16384, builder);
    }

    public LockedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public LockedQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long findMaxSeqBeforeWrapping() {
        this.pollingLock.lock();
        try {
            long l = (long)this.capacity + this.pollingSequence;
            return l;
        }
        finally {
            this.pollingLock.unlock();
        }
    }

    @Override
    public E nextToOffer() {
        long index;
        ++this.nextOfferValue;
        if ((index = this.nextOfferValue--) > this.maxSeq) {
            this.maxSeq = this.findMaxSeqBeforeWrapping();
            if (index > this.maxSeq) {
                return null;
            }
        }
        return this.data[(int)(index & (long)(this.capacity - 1))];
    }

    @Override
    public void offer(E e) {
        this.offeringLock.lock();
        this.offeringSequence = this.nextOfferValue;
        this.offeringLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long available() {
        this.offeringLock.lock();
        try {
            long l = this.offeringSequence - this.nextPollValue;
            return l;
        }
        finally {
            this.offeringLock.unlock();
        }
    }

    @Override
    public E poll() {
        return this.data[(int)(++this.nextPollValue & (long)(this.capacity - 1))];
    }

    @Override
    public void done() {
        this.pollingLock.lock();
        this.pollingSequence = this.nextPollValue;
        this.pollingLock.unlock();
    }
}

