/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import org.mentaqueue.Queue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class ConcurrentLinkedQueue<E>
implements Queue<E> {
    private final java.util.concurrent.ConcurrentLinkedQueue<E> queue = new java.util.concurrent.ConcurrentLinkedQueue();
    private final Builder<E> builder;
    private E elementToReturn = null;

    public ConcurrentLinkedQueue(Builder<E> builder) {
        this.builder = builder;
    }

    public ConcurrentLinkedQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToOffer() {
        return this.builder.newInstance();
    }

    @Override
    public void offer(E e) {
        this.queue.offer(e);
    }

    @Override
    public long available() {
        this.elementToReturn = this.queue.poll();
        return this.elementToReturn != null ? 1L : 0L;
    }

    @Override
    public E poll() {
        return this.elementToReturn;
    }

    @Override
    public void done() {
        this.elementToReturn = null;
    }
}

