/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import java.util.LinkedList;
import org.mentaqueue.Queue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class BlockingQueue<E>
implements Queue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final LinkedList<E> queue;
    private final Object lock = new Object();
    private final int capacity;
    private final Builder<E> builder;

    public BlockingQueue(int capacity, Builder<E> builder) {
        this.queue = new LinkedList();
        this.capacity = capacity;
        this.builder = builder;
    }

    public BlockingQueue(Builder<E> builder) {
        this(16416, builder);
    }

    public BlockingQueue(Class<E> klass) {
        this(BuilderUtils.createBuilder(klass));
    }

    public BlockingQueue(int capacity, Class<E> klass) {
        this(capacity, BuilderUtils.createBuilder(klass));
    }

    @Override
    public E nextToOffer() {
        return this.builder.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(E e) {
        Object object = this.lock;
        synchronized (object) {
            int size = this.queue.size();
            if (size == this.capacity) {
                try {
                    this.lock.wait();
                }
                catch (Exception exc) {
                    return;
                }
            }
            this.queue.add(e);
            if (size == 0) {
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long available() {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() == 0) {
                try {
                    this.lock.wait();
                }
                catch (Exception e) {
                    return 0L;
                }
            }
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object object = this.lock;
        synchronized (object) {
            E elem = this.queue.removeFirst();
            if (this.queue.size() == this.capacity - 1) {
                this.lock.notify();
            }
            return elem;
        }
    }

    @Override
    public void done() {
    }
}

