/*
 * Decompiled with CFR 0.152.
 */
package org.mentaqueue;

import java.util.concurrent.ArrayBlockingQueue;
import org.mentaqueue.Queue;
import org.mentaqueue.util.Builder;
import org.mentaqueue.util.BuilderUtils;

public class BlockingArrayQueue<E>
implements Queue<E> {
    private static final int DEFAULT_CAPACITY = 16416;
    private final ArrayBlockingQueue<E> queue;
    private final Builder<E> builder;

    public BlockingArrayQueue(int capacity, Builder<E> builder) {
        this.queue = new ArrayBlockingQueue(capacity);
        this.builder = builder;
    }

    public BlockingArrayQueue(Class<E> klass) {
        this(16416, BuilderUtils.createBuilder(klass));
    }

    public BlockingArrayQueue(Builder<E> builder) {
        this(16416, builder);
    }

    @Override
    public E nextToOffer() {
        return this.builder.newInstance();
    }

    @Override
    public void offer(E e) {
        try {
            this.queue.put(e);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public long available() {
        return this.queue.size();
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    @Override
    public void done() {
    }
}

