/*
 * MentaQueue => http://mentaqueue.soliveirajr.com
 * Copyright (C) 2012  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentaqueue;

import static org.mentaqueue.util.BuilderUtils.*;

import org.mentaqueue.util.Builder;

public class ConcurrentLinkedQueue<E> implements Queue<E> {

	private final java.util.concurrent.ConcurrentLinkedQueue<E> queue;
	private final Builder<E> builder;
	private E elementToReturn = null;

	public ConcurrentLinkedQueue(Builder<E> builder) {
		queue = new java.util.concurrent.ConcurrentLinkedQueue<E>();
		this.builder = builder;
	}

	public ConcurrentLinkedQueue(Class<E> klass) {
		this(createBuilder(klass));
	}
	
	@Override
	public E nextToOffer() {
		return builder.newInstance();
	}

	@Override
	public void offer(E e) {
		queue.offer(e);
	}

	@Override
	public long available() {
		elementToReturn = queue.poll();
		return elementToReturn != null ? 1 : 0;
	}

	@Override
	public E poll() {
		return elementToReturn;
	}

	@Override
	public void done() {
		elementToReturn = null;
	}
}
