/*
 * MentaQueue => http://mentaqueue.soliveirajr.com
 * Copyright (C) 2012  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentaqueue;

import static org.mentaqueue.util.BuilderUtils.*;

import org.mentaqueue.util.Builder;

public class BlockingLinkedQueue<E> implements Queue<E> {

	private final static int DEFAULT_CAPACITY = 1026 * 16;

	private final java.util.concurrent.LinkedBlockingQueue<E> queue;
	private final Builder<E> builder;

	public BlockingLinkedQueue(int capacity, Builder<E> builder) {
		queue = new java.util.concurrent.LinkedBlockingQueue<E>(capacity);
		this.builder = builder;
	}

	public BlockingLinkedQueue(Class<E> klass) {
		this(DEFAULT_CAPACITY, createBuilder(klass));
	}
	
	public BlockingLinkedQueue(Builder<E> builder) {
		this(DEFAULT_CAPACITY, builder);
	}
	
	@Override
	public E nextToOffer() {
		return builder.newInstance();
	}

	@Override
	public void offer(E e) {
		try {
			queue.put(e);
		} catch(Exception exc) {
			throw new RuntimeException(exc);
		}
	}

	@Override
	public long available() {
		return queue.size();
	}

	@Override
	public E poll() {
		return queue.poll();
	}

	@Override
	public void done() {
	}
}
