/*
 * MentaQueue => http://mentaqueue.soliveirajr.com
 * Copyright (C) 2012  Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.mentaqueue.util;

import org.mentaqueue.Queue;

public class NonBatchingQueue<E> implements Queue<E> {

	private final Queue<E> delegate;

	public NonBatchingQueue(Queue<E> delegate) {
		this.delegate = delegate;
	}

	@Override
	public E nextToOffer() {
		return delegate.nextToOffer();
	}

	@Override
	public void offer(E e) {
		delegate.offer(e);
	}

	@Override
	public long available() {
		return delegate.available() > 0 ? 1 : 0;
	}

	@Override
	public E poll() {
		return delegate.poll();
	}

	@Override
	public void done() {
		delegate.done();
	}

	public Queue<E> getDelegate() {
		return delegate;
	}
}