/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import org.mentabean.sql.TableAlias;
import org.mentabean.util.PropertiesProxy;

public class SQLBuilder
implements CharSequence {
    private final StringBuilder sb;
    private final TableAlias<?>[] aliases;

    public SQLBuilder() {
        this.sb = new StringBuilder();
        this.aliases = null;
    }

    public SQLBuilder(int initialCapacity) {
        this.sb = new StringBuilder(initialCapacity);
        this.aliases = null;
    }

    public SQLBuilder(TableAlias<?> ... aliases) {
        this.sb = new StringBuilder();
        this.aliases = aliases;
    }

    public SQLBuilder(int initialCapacity, TableAlias<?> ... aliases) {
        this.sb = new StringBuilder(initialCapacity);
        this.aliases = aliases;
    }

    private TableAlias<?> findAlias(Object instance) {
        if (this.aliases == null) {
            return null;
        }
        for (TableAlias<?> alias : this.aliases) {
            if (alias.proxy() != instance) continue;
            return alias;
        }
        return null;
    }

    public SQLBuilder column(Object obj) {
        if (obj instanceof String) {
            this.append((String)obj);
        } else {
            Object[] instances = PropertiesProxy.getBeanInstances();
            if (instances == null || instances.length == 0) {
                throw new IllegalStateException("Cannot find bean instance!");
            }
            Object instance = instances[0];
            TableAlias<?> alias = this.findAlias(instance);
            if (alias == null) {
                throw new IllegalStateException("Cannot find alias: " + instance);
            }
            this.append(alias.column(null));
        }
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    public int capacity() {
        return this.sb.capacity();
    }

    public int hashCode() {
        return this.sb.hashCode();
    }

    public void ensureCapacity(int minimumCapacity) {
        this.sb.ensureCapacity(minimumCapacity);
    }

    public void trimToSize() {
        this.sb.trimToSize();
    }

    public void setLength(int newLength) {
        this.sb.setLength(newLength);
    }

    public boolean equals(Object obj) {
        return this.sb.equals(obj);
    }

    public SQLBuilder append(Object obj) {
        this.sb.append(obj);
        return this;
    }

    public SQLBuilder append(String str) {
        this.sb.append(str);
        return this;
    }

    public SQLBuilder append(StringBuffer sb) {
        this.sb.append(sb);
        return this;
    }

    public SQLBuilder append(CharSequence s) {
        this.sb.append(s);
        return this;
    }

    public int codePointAt(int index) {
        return this.sb.codePointAt(index);
    }

    public SQLBuilder append(CharSequence s, int start, int end) {
        this.sb.append(s, start, end);
        return this;
    }

    public SQLBuilder append(char[] str) {
        this.sb.append(str);
        return this;
    }

    public SQLBuilder append(char[] str, int offset, int len) {
        this.sb.append(str, offset, len);
        return this;
    }

    public SQLBuilder append(boolean b) {
        this.sb.append(b);
        return this;
    }

    public SQLBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    public SQLBuilder append(int i) {
        this.sb.append(i);
        return this;
    }

    public int codePointBefore(int index) {
        return this.sb.codePointBefore(index);
    }

    public SQLBuilder append(long lng) {
        this.sb.append(lng);
        return this;
    }

    public SQLBuilder append(float f) {
        this.sb.append(f);
        return this;
    }

    public SQLBuilder append(double d) {
        this.sb.append(d);
        return this;
    }

    public SQLBuilder appendCodePoint(int codePoint) {
        this.sb.appendCodePoint(codePoint);
        return this;
    }

    public SQLBuilder delete(int start, int end) {
        this.sb.delete(start, end);
        return this;
    }

    public SQLBuilder deleteCharAt(int index) {
        this.sb.deleteCharAt(index);
        return this;
    }

    public SQLBuilder replace(int start, int end, String str) {
        this.sb.replace(start, end, str);
        return this;
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return this.sb.codePointCount(beginIndex, endIndex);
    }

    public SQLBuilder insert(int index, char[] str, int offset, int len) {
        this.sb.insert(index, str, offset, len);
        return this;
    }

    public SQLBuilder insert(int offset, Object obj) {
        this.sb.insert(offset, obj);
        return this;
    }

    public SQLBuilder insert(int offset, String str) {
        this.sb.insert(offset, str);
        return this;
    }

    public SQLBuilder insert(int offset, char[] str) {
        this.sb.insert(offset, str);
        return this;
    }

    public SQLBuilder insert(int dstOffset, CharSequence s) {
        this.sb.insert(dstOffset, s);
        return this;
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return this.sb.offsetByCodePoints(index, codePointOffset);
    }

    public SQLBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        this.sb.insert(dstOffset, s, start, end);
        return this;
    }

    public SQLBuilder insert(int offset, boolean b) {
        this.sb.insert(offset, b);
        return this;
    }

    public SQLBuilder insert(int offset, char c) {
        this.sb.insert(offset, c);
        return this;
    }

    public SQLBuilder insert(int offset, int i) {
        this.sb.insert(offset, i);
        return this;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.sb.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public SQLBuilder insert(int offset, long l) {
        this.sb.insert(offset, l);
        return this;
    }

    public SQLBuilder insert(int offset, float f) {
        this.sb.insert(offset, f);
        return this;
    }

    public SQLBuilder insert(int offset, double d) {
        this.sb.insert(offset, d);
        return this;
    }

    public int indexOf(String str) {
        return this.sb.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.sb.indexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.sb.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.sb.lastIndexOf(str, fromIndex);
    }

    public SQLBuilder reverse() {
        this.sb.reverse();
        return this;
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public void setCharAt(int index, char ch) {
        this.sb.setCharAt(index, ch);
    }

    public String substring(int start) {
        return this.sb.substring(start);
    }

    public String substring(int start, int end) {
        return this.sb.substring(start, end);
    }
}

