/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;

public class DoubleType
implements DBType<Double> {
    private boolean canBeNull = true;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public DoubleType nullable(boolean flag) {
        DoubleType d = new DoubleType();
        d.canBeNull = flag;
        return d;
    }

    @Override
    public String getAnsiType() {
        return "double precision";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Double getFromResultSet(ResultSet rset, int index) throws SQLException {
        Double x = rset.getDouble(index);
        if (rset.wasNull()) {
            return null;
        }
        return x;
    }

    @Override
    public Double getFromResultSet(ResultSet rset, String field) throws SQLException {
        Double x = rset.getDouble(field);
        if (rset.wasNull()) {
            return null;
        }
        return x;
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Double.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Double value) throws SQLException {
        if (value == null || value.isNaN() || value.isInfinite()) {
            stmt.setNull(index, 8);
        } else {
            stmt.setDouble(index, value);
        }
    }
}

