/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;
import org.mentabean.jdbc.AnsiSQLBeanSession;
import org.mentabean.jdbc.QueryBuilder;
import org.mentabean.sql.Condition;
import org.mentabean.sql.Function;
import org.mentabean.sql.param.Param;
import org.mentabean.sql.param.ParamFunction;
import org.mentabean.sql.param.ParamSubQuery;
import org.mentabean.type.GenericType;

public class Sentence
implements Function,
Condition {
    private Param param;
    private String name;
    private String property;
    private DBType<?> returnType = new GenericType();

    public Sentence(Param param) {
        this.param = param;
    }

    public Sentence(QueryBuilder.Query query) {
        this.param = new ParamSubQuery(query);
    }

    public Sentence(Function function) {
        this.param = new ParamFunction(function);
    }

    public Sentence fromProperty(Object property) {
        this.property = AnsiSQLBeanSession.getProperties(new Object[]{property})[0];
        if (this.name == null) {
            this.name = this.property.replace('.', '_');
        }
        return this;
    }

    public Sentence name(String name) {
        this.name = name;
        return this;
    }

    public Sentence returnType(DBType<?> type) {
        this.returnType = type;
        return this;
    }

    public <T> T getValue(ResultSet rset) throws SQLException {
        return (T)this.returnType.getFromResultSet(rset, this.name);
    }

    public DBType<?> getReturnType() {
        return this.returnType;
    }

    public String getProperty() {
        return this.property;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Param[] getParams() {
        return new Param[]{this.param};
    }

    @Override
    public String build() {
        return "(" + this.param.paramInQuery() + ")";
    }
}

