/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.DBField;
import org.mentabean.jdbc.AnsiSQLBeanSession;
import org.mentabean.util.Limit;
import org.mentabean.util.OrderBy;

public class OracleBeanSession
extends AnsiSQLBeanSession {
    public OracleBeanSession(BeanManager beanManager, Connection conn) {
        super(beanManager, conn);
    }

    @Override
    protected String getCurrentTimestampCommand() {
        return "sysdate";
    }

    @Override
    protected StringBuilder handleLimit(StringBuilder sb, OrderBy orderBy, Limit limit) {
        if (limit == null || limit.intValue() <= 0) {
            return sb;
        }
        StringBuilder sbLimit = new StringBuilder(sb.length() + 32);
        if (orderBy != null && !orderBy.isEmpty()) {
            sbLimit.append("SELECT * FROM (").append(sb.toString()).append(") where rowcount <= ").append(limit);
        } else {
            sbLimit.append(sb.toString()).append(" AND rownum <= ").append(limit);
        }
        return sbLimit;
    }

    @Override
    public void insert(Object bean) {
        ResultSet rset;
        PreparedStatement stmt;
        block10: {
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            DBField seqField = bc.getSequenceField();
            if (seqField == null) {
                super.insert(bean);
                this.dispatchAfterInsert(bean);
                return;
            }
            stmt = null;
            rset = null;
            StringBuilder sb = new StringBuilder(128);
            sb.append("select ");
            String seqName = bc.getSequenceName();
            if (seqName != null) {
                sb.append(seqName);
            } else {
                sb.append("seq_").append(seqField.getDbName()).append("_").append(bc.getTableName());
            }
            sb.append(".nextval from ").append(bc.getTableName());
            try {
                stmt = this.conn.prepareStatement(sb.toString());
                rset = stmt.executeQuery();
                if (!rset.next()) break block10;
                long id = rset.getLong(1);
                try {
                    this.injectValue(bean, seqField.getName(), id, Integer.class);
                }
                catch (Exception e) {
                    this.injectValue(bean, seqField.getName(), id, Long.class);
                }
            }
            catch (Exception e) {
                try {
                    throw new BeanException(e);
                }
                catch (Throwable throwable) {
                    OracleBeanSession.close(stmt, rset);
                    throw throwable;
                }
            }
        }
        OracleBeanSession.close(stmt, rset);
        super.insert(bean);
        this.dispatchAfterInsert(bean);
    }
}

