/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;
import org.mentabean.type.SizedType;

public class EnumValueType
implements DBType<Enum<?>>,
SizedType {
    private final Class<? extends Enum<?>> enumType;
    private final int size;
    private boolean canBeNull = false;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public EnumValueType nullable(boolean flag) {
        EnumValueType d = new EnumValueType(this.enumType);
        d.canBeNull = flag;
        return d;
    }

    public EnumValueType(Class<? extends Enum<?>> enumType) {
        this.enumType = enumType;
        this.size = this.calcSize();
    }

    @Override
    public String getAnsiType() {
        return "varchar";
    }

    public EnumValueType size(int size) {
        throw new UnsupportedOperationException("Cannot set the size on a " + this);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private int calcSize() {
        Enum<?>[] all = this.enumType.getEnumConstants();
        int max = 0;
        for (Enum<?> o : all) {
            max = Math.max(max, o.name().length());
        }
        return max;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.enumType.getSimpleName();
    }

    @Override
    public Enum<?> getFromResultSet(ResultSet rset, int index) throws SQLException {
        String s = rset.getString(index);
        if (s == null) {
            return null;
        }
        return Enum.valueOf(this.enumType, s);
    }

    @Override
    public Enum<?> getFromResultSet(ResultSet rset, String field) throws SQLException {
        String s = rset.getString(field);
        if (s == null) {
            return null;
        }
        return Enum.valueOf(this.enumType, s);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return this.enumType;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Enum<?> value) throws SQLException {
        if (value == null) {
            stmt.setString(index, null);
        } else if (this.enumType.isAssignableFrom(value.getClass())) {
            String s = value.name();
            stmt.setString(index, s);
        } else {
            throw new IllegalArgumentException("Value '" + value + "' from '" + value.getClass() + "' is not an enum!");
        }
    }
}

