/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;

public class BigDecimalType
implements DBType<BigDecimal> {
    private boolean canBeNull = true;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public BigDecimalType nullable(boolean flag) {
        BigDecimalType b = new BigDecimalType();
        this.canBeNull = flag;
        return b;
    }

    @Override
    public String getAnsiType() {
        return "double precision";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public BigDecimal getFromResultSet(ResultSet rset, int index) throws SQLException {
        BigDecimal bd = rset.getBigDecimal(index);
        if (rset.wasNull()) {
            return null;
        }
        return bd;
    }

    @Override
    public BigDecimal getFromResultSet(ResultSet rset, String field) throws SQLException {
        BigDecimal bd = rset.getBigDecimal(field);
        if (rset.wasNull()) {
            return null;
        }
        return bd;
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return BigDecimal.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, BigDecimal value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 3);
        } else {
            stmt.setBigDecimal(index, value);
        }
    }
}

