/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.jdbc.AnsiSQLBeanSession;
import org.mentabean.type.ByteArrayType;
import org.mentabean.type.LongType;
import org.mentabean.util.Limit;
import org.mentabean.util.OrderBy;

public class PostgreSQLBeanSession
extends AnsiSQLBeanSession {
    public PostgreSQLBeanSession(BeanManager beanManager, Connection conn) {
        super(beanManager, conn);
    }

    @Override
    protected String getCurrentTimestampCommand() {
        return "current_timestamp";
    }

    @Override
    protected StringBuilder handleLimit(StringBuilder sb, OrderBy orderBy, Limit limit) {
        if (limit == null || limit.intValue() <= 0) {
            return sb;
        }
        StringBuilder sbLimit = new StringBuilder(sb.length() + 32);
        sbLimit.append(sb.toString()).append(" LIMIT ").append(limit);
        return sbLimit;
    }

    @Override
    public void insert(Object bean) {
        String seqName;
        StringBuilder sb;
        ResultSet rset;
        PreparedStatement stmt;
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        DBField seqField = bc.getSequenceField();
        if (seqField == null) {
            block18: {
                super.insert(bean);
                DBField autoIncrement = bc.getAutoIncrementField();
                if (autoIncrement == null) {
                    this.dispatchAfterInsert(bean);
                    return;
                }
                stmt = null;
                rset = null;
                sb = new StringBuilder("select lastval();");
                try {
                    stmt = this.conn.prepareStatement(sb.toString());
                    rset = stmt.executeQuery();
                    if (!rset.next()) break block18;
                    long id = rset.getLong(1);
                    try {
                        this.injectValue(bean, autoIncrement.getName(), id, Integer.class);
                    }
                    catch (Exception e) {
                        this.injectValue(bean, autoIncrement.getName(), id, Long.class);
                    }
                    this.dispatchAfterInsert(bean);
                }
                catch (Exception e) {
                    try {
                        throw new BeanException(e);
                    }
                    catch (Throwable throwable) {
                        PostgreSQLBeanSession.close(stmt, rset);
                        throw throwable;
                    }
                }
                PostgreSQLBeanSession.close(stmt, rset);
                return;
            }
            PostgreSQLBeanSession.close(stmt, rset);
        }
        if ((seqName = bc.getSequenceName()) == null) {
            seqName = bc.getTableName() + "_seq";
        }
        stmt = null;
        rset = null;
        sb = new StringBuilder();
        sb.append("select nextval ('").append(seqName).append("')");
        try {
            stmt = this.conn.prepareStatement(sb.toString());
            rset = stmt.executeQuery();
            if (rset.next()) {
                long id = rset.getLong(1);
                try {
                    this.injectValue(bean, seqField.getName(), id, Integer.class);
                }
                catch (Exception e) {
                    this.injectValue(bean, seqField.getName(), id, Long.class);
                }
            }
        }
        catch (Exception e) {
            throw new BeanException("Error preparing statement to insert in PostgreSQL", e);
        }
        finally {
            PostgreSQLBeanSession.close(stmt, rset);
        }
        super.insert(bean);
        this.dispatchAfterInsert(bean);
    }

    @Override
    protected boolean isVarcharUnlimitedSupported() {
        return true;
    }

    @Override
    protected String getDatabaseType(DBType<?> dbType) {
        if (dbType.getClass().equals(ByteArrayType.class)) {
            return "bytea";
        }
        if (dbType.getClass().equals(LongType.class)) {
            return "bigint";
        }
        return super.getDatabaseType(dbType);
    }
}

