/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.DBField;
import org.mentabean.jdbc.AnsiSQLBeanSession;
import org.mentabean.util.Limit;
import org.mentabean.util.OrderBy;

public class FirebirdBeanSession
extends AnsiSQLBeanSession {
    public FirebirdBeanSession(BeanManager beanManager, Connection conn) {
        super(beanManager, conn);
    }

    @Override
    protected String getCurrentTimestampCommand() {
        return "current_timestamp";
    }

    @Override
    protected StringBuilder handleLimit(StringBuilder sb, OrderBy orderBy, Limit limit) {
        if (limit == null || limit.intValue() <= 0) {
            return sb;
        }
        String query = sb.toString();
        if (query.toLowerCase().startsWith("select ")) {
            throw new BeanException("Got a limit query that does not start with select: " + query);
        }
        String withoutSelect = query.substring("select".length());
        StringBuilder sbLimit = new StringBuilder(withoutSelect.length() + 64);
        sbLimit.append("SELECT first(").append(limit).append(")").append(withoutSelect);
        return sbLimit;
    }

    @Override
    public void insert(Object bean) {
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        DBField autoIncrement = bc.getAutoIncrementField();
        if (autoIncrement == null) {
            super.insert(bean);
            this.dispatchAfterInsert(bean);
            return;
        }
        AnsiSQLBeanSession.QueryAndValues qav = this.prepareInsertQuery(bean);
        StringBuilder sb = qav.sb;
        List<AnsiSQLBeanSession.Value> values = qav.values;
        if (this.conn == null) {
            throw new BeanException("Connection is null!");
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            sb.append(" returning ").append(autoIncrement.getDbName());
            if (DEBUG) {
                System.out.println("INSERT SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Map<String, AnsiSQLBeanSession.Value> fieldsLoaded = this.bindToInsertStatement(stmt, values);
            rset = stmt.executeQuery();
            if (!rset.next()) {
                throw new BeanException("Nothing was inserted! Insert returned no result set!");
            }
            int id = rset.getInt(autoIncrement.getDbName());
            this.injectValue(bean, autoIncrement.getName(), id, Integer.class);
            this.loaded.put(bean, fieldsLoaded);
            this.dispatchAfterInsert(bean);
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                FirebirdBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        FirebirdBeanSession.close(stmt, rset);
    }
}

