/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mentabean.util.PropertiesProxy;

public class OrderBy {
    private final Map<String, SortOrder> fields = new LinkedHashMap<String, SortOrder>();

    public OrderBy orderByAsc(String field) {
        if (field == null) {
            return this.orderByAsc((Object)null);
        }
        this.fields.put(field, SortOrder.ASC);
        return this;
    }

    public OrderBy orderByAsc(Object field) {
        return this.orderByAsc(PropertiesProxy.getPropertyName());
    }

    public OrderBy orderByDesc(String field) {
        if (field == null) {
            return this.orderByDesc((Object)null);
        }
        this.fields.put(field, SortOrder.DESC);
        return this;
    }

    public OrderBy orderByDesc(Object field) {
        return this.orderByDesc(PropertiesProxy.getPropertyName());
    }

    public String toString() {
        if (this.fields.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (String field : this.fields.keySet()) {
            SortOrder so = this.fields.get(field);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(field).append(" ").append(so.toString().toLowerCase());
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

