/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.BeanException;
import org.mentabean.DBType;

public class EnumIdType
implements DBType<Enum<?>> {
    private final Class<? extends Enum<?>> enumType;
    private final Method fromIdMethod;
    private final Method getIdMethod;
    private boolean canBeNull = false;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public EnumIdType nullable(boolean flag) {
        EnumIdType d = new EnumIdType(this.enumType);
        d.canBeNull = flag;
        return d;
    }

    public EnumIdType(Class<? extends Enum<?>> enumType) {
        this.enumType = enumType;
        this.fromIdMethod = EnumIdType.getFromIdMethod(enumType);
        this.getIdMethod = EnumIdType.getGetIdMethod(enumType);
    }

    @Override
    public String getAnsiType() {
        return "smallint";
    }

    private static Method getFromIdMethod(Class<? extends Enum<?>> enumType) {
        try {
            return enumType.getMethod("fromId", Integer.TYPE);
        }
        catch (Exception e) {
            throw new BeanException("Cannot find fromId(int) method from enum class: " + enumType, e);
        }
    }

    private static Method getGetIdMethod(Class<? extends Enum<?>> enumType) {
        try {
            return enumType.getMethod("getId", null);
        }
        catch (Exception e) {
            throw new BeanException("Cannot find getId() method from enum class: " + enumType, e);
        }
    }

    private Enum<?> fromId(int id) {
        try {
            return (Enum)this.fromIdMethod.invoke(null, id);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    private int getId(Enum<?> theEnum) {
        try {
            return (Integer)this.getIdMethod.invoke(theEnum, (Object[])null);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.enumType.getSimpleName();
    }

    @Override
    public Enum<?> getFromResultSet(ResultSet rset, int index) throws SQLException {
        int id = rset.getInt(index);
        if (rset.wasNull()) {
            return null;
        }
        return this.fromId(id);
    }

    @Override
    public Enum<?> getFromResultSet(ResultSet rset, String field) throws SQLException {
        int id = rset.getInt(field);
        if (rset.wasNull()) {
            return null;
        }
        return this.fromId(id);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return this.enumType;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Enum<?> value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 4);
        } else if (this.enumType.isAssignableFrom(value.getClass())) {
            int id = this.getId(value);
            stmt.setInt(index, id);
        } else {
            throw new IllegalArgumentException("Value '" + value + "' from '" + value.getClass() + "' is not an enum!");
        }
    }

    public static void main(String[] args) throws Exception {
        EnumIdType eit = new EnumIdType(Test.class);
        System.out.println(eit.fromId(2));
        System.out.println(eit.getId(Test.T3));
    }

    public static enum Test {
        T1(1),
        T2(2),
        T3(3);

        private final int id;

        private Test(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Test fromId(int id) {
            for (Test t : Test.values()) {
                if (t.getId() != id) continue;
                return t;
            }
            return null;
        }
    }
}

