/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.index.SpatialTreeIndex;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueLong;

public class MVSpatialIndex
extends BaseIndex
implements SpatialIndex,
MVIndex {
    final MVTable mvTable;
    private final String mapName;
    private TransactionStore.TransactionMap<SpatialKey, Value> dataMap;
    private MVRTreeMap<TransactionStore.VersionedValue> spatialMap;

    public MVSpatialIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        if (indexColumnArray.length != 1) {
            throw DbException.getUnsupportedException("Can only index one column");
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if ((indexColumn.sortType & 1) != 0) {
            throw DbException.getUnsupportedException("Cannot index in descending order");
        }
        if ((indexColumn.sortType & 2) != 0) {
            throw DbException.getUnsupportedException("Nulls first is not supported");
        }
        if ((indexColumn.sortType & 4) != 0) {
            throw DbException.getUnsupportedException("Nulls last is not supported");
        }
        if (indexColumn.column.getType() != 22) {
            throw DbException.getUnsupportedException("Spatial index on non-geometry column, " + indexColumn.column.getCreateSQL());
        }
        this.mvTable = mVTable;
        this.initBaseIndex(mVTable, n, string, indexColumnArray, indexType);
        if (!this.database.isStarting()) {
            MVSpatialIndex.checkIndexColumnTypes(indexColumnArray);
        }
        this.mapName = "index." + this.getId();
        ValueDataType valueDataType = new ValueDataType(null, null, null);
        TransactionStore.VersionedValueType versionedValueType = new TransactionStore.VersionedValueType(valueDataType);
        MVRTreeMap.Builder builder = new MVRTreeMap.Builder().valueType(versionedValueType);
        this.spatialMap = (MVRTreeMap)database.getMvStore().getStore().openMap(this.mapName, builder);
        this.dataMap = this.mvTable.getTransaction(null).openMap(this.spatialMap);
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> list) {
        throw DbException.throwInternalError();
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        SpatialKey spatialKey;
        Iterator<SpatialKey> iterator;
        MVRTreeMap.RTreeCursor rTreeCursor;
        TransactionStore.TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        SpatialKey spatialKey2 = this.getKey(row);
        if (this.indexType.isUnique()) {
            rTreeCursor = this.spatialMap.findContainedKeys(spatialKey2);
            iterator = transactionMap.wrapIterator(rTreeCursor, false);
            while (iterator.hasNext()) {
                spatialKey = iterator.next();
                if (!spatialKey.equalsIgnoringId(spatialKey2)) continue;
                throw this.getDuplicateKeyException(spatialKey2.toString());
            }
        }
        try {
            transactionMap.put(spatialKey2, ValueLong.get(0L));
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, illegalStateException, this.table.getName());
        }
        if (this.indexType.isUnique()) {
            rTreeCursor = this.spatialMap.findContainedKeys(spatialKey2);
            iterator = transactionMap.wrapIterator(rTreeCursor, true);
            while (iterator.hasNext()) {
                spatialKey = iterator.next();
                if (!spatialKey.equalsIgnoringId(spatialKey2) || transactionMap.isSameTransaction(spatialKey)) continue;
                transactionMap.remove(spatialKey2);
                if (transactionMap.get(spatialKey) != null) {
                    throw this.getDuplicateKeyException(spatialKey.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    private SpatialKey getKey(SearchRow searchRow) {
        if (searchRow == null) {
            return null;
        }
        Value value = searchRow.getValue(this.columnIds[0]);
        Geometry geometry = ((ValueGeometry)value.convertTo(22)).getGeometryNoCopy();
        Envelope envelope = geometry.getEnvelopeInternal();
        return new SpatialKey(searchRow.getKey(), (float)envelope.getMinX(), (float)envelope.getMaxX(), (float)envelope.getMinY(), (float)envelope.getMaxY());
    }

    @Override
    public void remove(Session session, Row row) {
        SpatialKey spatialKey = this.getKey(row);
        TransactionStore.TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(spatialKey);
            if (value == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, illegalStateException, this.table.getName());
        }
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(tableFilter.getSession());
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session);
    }

    private Cursor find(Session session) {
        Iterator<Object> iterator = this.spatialMap.keyIterator(null);
        TransactionStore.TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        Iterator<Object> iterator2 = transactionMap.wrapIterator(iterator, false);
        return new MVStoreCursor(session, iterator2);
    }

    @Override
    public Cursor findByGeometry(TableFilter tableFilter, SearchRow searchRow) {
        Session session = tableFilter.getSession();
        if (searchRow == null) {
            return this.find(session);
        }
        MVRTreeMap.RTreeCursor rTreeCursor = this.spatialMap.findIntersectingKeys(this.getEnvelope(searchRow));
        TransactionStore.TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        Iterator<SpatialKey> iterator = transactionMap.wrapIterator(rTreeCursor, false);
        return new MVStoreCursor(session, iterator);
    }

    private SpatialKey getEnvelope(SearchRow searchRow) {
        Value value = searchRow.getValue(this.columnIds[0]);
        Geometry geometry = ((ValueGeometry)value.convertTo(22)).getGeometryNoCopy();
        Envelope envelope = geometry.getEnvelopeInternal();
        return new SpatialKey(searchRow.getKey(), (float)envelope.getMinX(), (float)envelope.getMaxX(), (float)envelope.getMinY(), (float)envelope.getMaxY());
    }

    SearchRow getRow(SpatialKey spatialKey) {
        Row row = this.mvTable.getTemplateRow();
        row.setKey(spatialKey.getId());
        return row;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter tableFilter, SortOrder sortOrder) {
        return this.getCostRangeIndex(nArray, this.table.getRowCountApproximation(), tableFilter, sortOrder);
    }

    @Override
    protected long getCostRangeIndex(int[] nArray, long l, TableFilter tableFilter, SortOrder sortOrder) {
        return SpatialTreeIndex.getCostRangeIndex(nArray, l, this.columns);
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        if (!bl) {
            throw DbException.throwInternalError("Spatial Index can only be fetch in ascending order");
        }
        return this.find(session);
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<SpatialKey, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.TransactionMap<SpatialKey, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
        return this.dataMap.getInstance(transaction, Long.MAX_VALUE);
    }

    class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<SpatialKey> it;
        private SpatialKey current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<SpatialKey> iterator) {
            this.session = session;
            this.it = iterator;
        }

        @Override
        public Row get() {
            SearchRow searchRow;
            if (this.row == null && (searchRow = this.getSearchRow()) != null) {
                this.row = MVSpatialIndex.this.mvTable.getRow(this.session, searchRow.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSpatialIndex.this.getRow(this.current);
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.next();
            this.searchRow = null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

