/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.mentabean.BeanException;

public abstract class PropertiesProxy {
    public static PropertiesProxy INSTANCE;
    private static final ThreadLocal<List<String>> propertyNames;
    private static final ThreadLocal<List<Object>> beanInstances;
    private String chainProp;
    private static Class<?>[] ignored;

    public PropertiesProxy(String chainProp) {
        this.chainProp = chainProp;
    }

    private PropertiesProxy createInstance(String chainProp) {
        try {
            return (PropertiesProxy)this.getClass().getConstructor(String.class).newInstance(chainProp);
        }
        catch (Exception e) {
            throw new BeanException("Was not able to get PropertiesProxy instance!", e);
        }
    }

    public static <E> E create(Class<E> klass) {
        PropertiesProxy pp = INSTANCE.createInstance(null);
        return pp.createInternal(klass);
    }

    public static String getPropertyName() {
        List<String> list = propertyNames.get();
        if (list == null || list.size() != 1) {
            throw new BeanException("Was not able to get property name through the proxy!");
        }
        String propName = list.get(0);
        list.clear();
        List<Object> beans = beanInstances.get();
        if (beans != null) {
            beans.clear();
        }
        return propName;
    }

    public static Object[] getBeanInstances() {
        List<Object> list = beanInstances.get();
        if (list == null || list.size() == 0) {
            throw new BeanException("Was not able to get bean instances through the proxy!");
        }
        Object[] array = new Object[list.size()];
        array = list.toArray(array);
        list.clear();
        return array;
    }

    public static void addBeanInstance(Object proxy) {
        List<Object> list = beanInstances.get();
        if (list == null) {
            list = new LinkedList<Object>();
            beanInstances.set(list);
        }
        list.add(proxy);
    }

    public static void addPropertyName(String name) {
        List<String> list = propertyNames.get();
        if (list == null) {
            list = new LinkedList<String>();
            propertyNames.set(list);
        }
        list.add(name);
    }

    public static boolean hasBeanInstance() {
        return PropertiesProxy.hasElements((Collection)beanInstances.get());
    }

    public static boolean hasProperties() {
        return PropertiesProxy.hasElements((Collection)propertyNames.get());
    }

    private static boolean hasElements(Collection<?> coll) {
        return coll != null && coll.size() > 0;
    }

    public static String[] getPropertyNames() {
        List<String> list = propertyNames.get();
        if (list == null || list.size() == 0) {
            throw new BeanException("Was not able to get property names through the proxy!");
        }
        String[] array = new String[list.size()];
        array = list.toArray(array);
        list.clear();
        List<Object> beans = beanInstances.get();
        if (beans != null) {
            beans.clear();
        }
        return array;
    }

    protected static String getPropName(Method method) {
        String propName;
        String methodName = method.getName();
        Class<?> propType = method.getReturnType();
        if (propType.equals(Void.class)) {
            return null;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params != null && params.length > 0) {
            return null;
        }
        if (methodName.startsWith("get") && methodName.length() > 3) {
            propName = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2 && (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class))) {
            propName = methodName.substring(2);
        } else {
            return null;
        }
        propName = propName.substring(0, 1).toLowerCase() + propName.substring(1);
        if (propName.equals("class")) {
            return null;
        }
        return propName;
    }

    protected static boolean isIgnored(Class<?> clazz) {
        for (Class<?> ign : ignored) {
            if (!ign.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    protected abstract <E> E createInternal(Class<E> var1);

    protected Object invoke(Object self, Method thisMethod, Object[] args) {
        List<String> list = propertyNames.get();
        if (list == null) {
            list = new LinkedList<String>();
            propertyNames.set(list);
        }
        String propName = PropertiesProxy.getPropName(thisMethod);
        if (this.chainProp != null) {
            list.add(this.chainProp + "." + propName);
            list.remove(this.chainProp);
        } else {
            list.add(propName);
        }
        List<Object> beans = beanInstances.get();
        if (beans == null) {
            beans = new LinkedList<Object>();
            beanInstances.set(beans);
        }
        beans.add(self);
        Class<?> propType = thisMethod.getReturnType();
        if (propType.equals(Boolean.TYPE)) {
            return false;
        }
        if (propType.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (propType.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (propType.equals(Long.TYPE)) {
            return 0L;
        }
        if (propType.equals(Integer.TYPE)) {
            return 0;
        }
        if (propType.equals(Short.TYPE)) {
            return (short)0;
        }
        if (propType.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (propType.equals(Double.TYPE)) {
            return 0.0;
        }
        if (Modifier.isFinal(propType.getModifiers()) || propType.isInterface()) {
            return null;
        }
        if (propType.isEnum()) {
            return null;
        }
        if (PropertiesProxy.isIgnored(propType)) {
            return null;
        }
        PropertiesProxy proxy = INSTANCE.createInstance(this.chainProp != null ? this.chainProp + "." + propName : propName);
        return proxy.createInternal(propType);
    }

    static {
        propertyNames = new ThreadLocal();
        beanInstances = new ThreadLocal();
        ignored = new Class[]{BigDecimal.class, Date.class, Timestamp.class, Time.class};
    }
}

