/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.sql;

import org.mentabean.BeanConfig;
import org.mentabean.BeanSession;
import org.mentabean.DBField;
import org.mentabean.util.PropertiesProxy;

public class TableAlias<E> {
    private final Class<? extends E> beanClass;
    private final String prefix;
    private final BeanSession session;
    private final BeanConfig config;
    private final E proxy;

    public TableAlias(BeanSession session, BeanConfig config, Class<? extends E> beanClass) {
        this(session, config, beanClass, null);
    }

    public TableAlias(BeanSession session, BeanConfig config, Class<? extends E> beanClass, String prefix) {
        this.beanClass = beanClass;
        this.prefix = prefix;
        this.session = session;
        this.config = config;
        this.proxy = PropertiesProxy.create(beanClass);
    }

    public String toString() {
        return "TableAlias [beanClass=" + this.beanClass.getSimpleName() + ", prefix=" + this.prefix + "]";
    }

    public String columns(Object ... props) {
        if (this.prefix != null) {
            return this.session.buildSelect(this.beanClass, this.prefix, props);
        }
        return this.session.buildSelect(this.beanClass, props);
    }

    public String columnsMinus(Object ... props) {
        if (this.prefix != null) {
            return this.session.buildSelectMinus(this.beanClass, this.prefix, props);
        }
        return this.session.buildSelectMinus(this.beanClass, props);
    }

    public String tableName() {
        if (this.prefix != null) {
            return this.config.getTableName() + " " + this.prefix;
        }
        return this.config.getTableName();
    }

    public String column(Object prop) {
        String propName = PropertiesProxy.getPropertyName();
        DBField field = this.config.getField(propName);
        if (field == null) {
            throw new IllegalStateException("Cannot find field for property \"" + propName + "\" on beanconfig: " + this.config);
        }
        if (this.prefix != null) {
            return this.prefix + "." + field.getDbName();
        }
        return field.getDbName();
    }

    public E pxy() {
        return this.proxy;
    }

    public E proxy() {
        return this.proxy;
    }

    public String prefix() {
        return this.prefix;
    }

    public Class<? extends E> beanClass() {
        return this.beanClass;
    }
}

