/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.DBField;
import org.mentabean.jdbc.AnsiSQLBeanSession;
import org.mentabean.sql.Condition;
import org.mentabean.sql.HasParams;
import org.mentabean.sql.Sentence;
import org.mentabean.sql.param.DefaultParamHandler;
import org.mentabean.sql.param.Param;
import org.mentabean.sql.param.ParamHandler;
import org.mentabean.sql.param.ParamValue;
import org.mentabean.util.PropertiesProxy;
import org.mentabean.util.SQLUtils;

public class QueryBuilder {
    private static final String REGEX = "(AND|OR|\\([\\s]*?\\)|WHERE|HAVING)[\\s]*?$";
    private static final String NO_CLAUSE_REGEX = ".*(WHERE|HAVING|\\()[\\s]*?$";
    private StringBuilder sb = new StringBuilder();
    private final AnsiSQLBeanSession session;
    private List<Object> paramValues = new ArrayList<Object>();
    private List<Alias<?>> selectAliases;
    private List<Alias<?>> createdAliases = new ArrayList();
    private Map<String, Sentence> sentences = new HashMap<String, Sentence>();
    private Alias aliasFrom;
    private int parenthesis = 0;
    private boolean clauseIf;
    private ParamHandler paramHandler;

    protected QueryBuilder(AnsiSQLBeanSession session) {
        this.session = session;
        this.paramHandler = new DefaultParamHandler();
    }

    protected QueryBuilder(AnsiSQLBeanSession session, ParamHandler paramHandler) {
        this.session = session;
        this.paramHandler = paramHandler;
    }

    public List<Alias<?>> getCreatedAliases() {
        return this.createdAliases;
    }

    public Select select(Alias<?> ... as) {
        return new Select(null, (Alias[])as);
    }

    public Select selectDistinct(Alias<?> ... as) {
        return new Select("DISTINCT", (Alias[])as);
    }

    public From selectFrom(Alias<?> as) {
        return this.select(as).from(as);
    }

    public From selectDistinctFrom(Alias<?> as) {
        return new Select("DISTINCT", new Alias[]{as}).from(as);
    }

    public Select select(Sentence ... sentences) {
        return new Select(null, sentences);
    }

    public Select selectDistinct(Sentence ... sentences) {
        return new Select("DISTINCT", sentences);
    }

    public QueryBuilder subQuery() {
        QueryBuilder qb = new QueryBuilder(this.session);
        qb.createdAliases = this.createdAliases;
        return qb;
    }

    public <T> Alias<T> aliasTo(Class<? extends T> clazz, String alias) {
        return new Alias(clazz, alias);
    }

    public <T> Alias<T> aliasTo(Class<? extends T> clazz) {
        return new Alias(clazz, clazz.getSimpleName().toLowerCase());
    }

    private void appendTable(Alias<?> a) {
        this.sb.append(((Alias)a).config.getTableName()).append(' ').append(((Alias)a).aliasStr);
    }

    private void append(Param param) {
        if (param != null) {
            this.sb.append(param.paramInQuery());
        }
        this.add(param);
    }

    private void add(Object param) {
        block4: {
            block3: {
                if (!(param instanceof HasParams)) break block3;
                HasParams hasParams = (HasParams)param;
                Param[] params = hasParams.getParams();
                if (params == null) break block4;
                for (Param p : params) {
                    this.add(p);
                }
                break block4;
            }
            Param p = this.paramHandler.findBetter(this, param);
            if (p != null && p.values() != null && p.values().length > 0) {
                for (Object value : p.values()) {
                    if (value == null) continue;
                    this.paramValues.add(value);
                }
            }
        }
    }

    private void applyRegex() {
        this.remove(REGEX);
    }

    private void remove(String regex) {
        this.sb = new StringBuilder(this.sb.toString().replaceAll(regex, ""));
    }

    private void addAnd() {
        if (this.clauseIf) {
            if (this.sb.toString().matches(NO_CLAUSE_REGEX)) {
                return;
            }
            this.applyRegex();
            this.sb.append(" AND ");
        }
    }

    private void addOr() {
        if (this.clauseIf) {
            if (this.sb.toString().matches(NO_CLAUSE_REGEX)) {
                return;
            }
            this.applyRegex();
            this.sb.append(" OR ");
        }
    }

    private void openPar() {
        ++this.parenthesis;
        this.sb.append('(');
    }

    private void closePar() {
        this.applyRegex();
        --this.parenthesis;
        this.sb.append(')');
        this.applyRegex();
        this.clauseIf = true;
    }

    private Alias<?> findAlias() {
        Object[] instances = PropertiesProxy.getBeanInstances();
        if (instances == null || instances.length == 0) {
            throw new IllegalStateException("Cannot find proxy instance!");
        }
        Object instance = instances[0];
        for (Alias<?> a : this.createdAliases) {
            if (a.pxy() != instance) continue;
            return a;
        }
        throw new IllegalStateException("Cannot find alias for " + instance);
    }

    public void finish() {
        for (Alias<?> a : this.selectAliases) {
            ((Alias)a).joined.clear();
        }
        this.paramValues.clear();
        this.sb = new StringBuilder();
    }

    public class Query {
        private Query() {
        }

        private PreparedStatement prepare(Object ... params) {
            try {
                PreparedStatement ppst = SQLUtils.prepare(QueryBuilder.this.session.getConnection(), this.getSQL(), params);
                if (AnsiSQLBeanSession.DEBUG_NATIVE) {
                    System.out.println("CUSTOM QUERY (NATIVE): " + ppst);
                }
                return ppst;
            }
            catch (SQLException e) {
                throw new BeanException("Error preparing statement", e);
            }
        }

        public PreparedStatement prepare() {
            return this.prepare(QueryBuilder.this.paramValues.toArray());
        }

        public <T> List<T> executeQuery() {
            PreparedStatement ppst = null;
            try {
                ppst = this.prepare();
                ResultSet rs = ppst.executeQuery();
                ArrayList<Object> list = new ArrayList<Object>();
                while (rs.next()) {
                    Object bean = QueryBuilder.this.aliasFrom.config.getBeanClass().newInstance();
                    QueryBuilder.this.aliasFrom.populateAll(rs, bean);
                    for (Sentence s : QueryBuilder.this.sentences.values()) {
                        QueryBuilder.this.session.injectValue(bean, s.getProperty(), s.getValue(rs), s.getReturnType().getTypeClass());
                    }
                    list.add(bean);
                }
                ArrayList<Object> arrayList = list;
                return arrayList;
            }
            catch (Exception e) {
                throw new BeanException("Unable to execute query from QueryBuilder\n" + e.getMessage(), e);
            }
            finally {
                QueryBuilder.this.finish();
                SQLUtils.close(ppst);
            }
        }

        public <T> T executeSentence() {
            if (QueryBuilder.this.sentences.values().size() != 1) {
                throw new BeanException("This query must have exactly one sentence to execute");
            }
            PreparedStatement ppst = null;
            try {
                ppst = this.prepare();
                ResultSet rs = ppst.executeQuery();
                if (rs.next()) {
                    if (!rs.isLast()) {
                        throw new BeanException("The query returns more than one result");
                    }
                    Sentence s = (Sentence)QueryBuilder.this.sentences.values().iterator().next();
                    Object t = s.getValue(rs);
                    return t;
                }
                T t = null;
                return t;
            }
            catch (Exception e) {
                throw new BeanException("Unable to execute sentence from QueryBuilder\n" + e.getMessage(), e);
            }
            finally {
                QueryBuilder.this.finish();
                SQLUtils.close(ppst);
            }
        }

        public <T> T getValueFromResultSet(ResultSet rs, String name) throws SQLException {
            Sentence s = (Sentence)QueryBuilder.this.sentences.get(name);
            if (s == null) {
                throw new BeanException("The sentence name '" + name + "' is not included in query");
            }
            return s.getValue(rs);
        }

        public String getSQL() {
            if (QueryBuilder.this.parenthesis != 0) {
                throw new BeanException("Invalid parenthesis");
            }
            QueryBuilder.this.applyRegex();
            if (AnsiSQLBeanSession.DEBUG) {
                System.out.println("CUSTOM QUERY: " + QueryBuilder.this.sb.toString());
            }
            return QueryBuilder.this.sb.toString();
        }

        public List<Object> getParamValues() {
            return QueryBuilder.this.paramValues;
        }
    }

    public static interface Appendable<T> {
        public T append(Param var1);
    }

    public static interface CanGroupBy {
        public GroupBy groupBy(Alias<?> ... var1);

        public GroupBy groupBy(Param ... var1);

        public GroupBy groupByProp(Alias<?> var1, Object ... var2);

        public GroupBy groupBy();
    }

    public static interface CanLimit {
        public Limit limit(Object var1);
    }

    public static interface CanOrder {
        public Order orderBy();
    }

    public static interface HasEndClause<T extends EndClause> {
        public T condition(String var1);

        public T condition(Condition var1);
    }

    public static interface HasInitClause<T extends InitClause> {
        public T clause(Object var1);

        public T clauseIf(boolean var1, Object var2);
    }

    public class Having
    extends Query
    implements Appendable<Having>,
    HasInitClause<InitClauseHaving> {
        private Having(boolean init) {
            if (init) {
                QueryBuilder.this.sb.append(" HAVING ");
            }
        }

        @Override
        public InitClauseHaving clauseIf(boolean clauseIf, Object param) {
            QueryBuilder.this.clauseIf = clauseIf;
            return new InitClauseHaving(param);
        }

        @Override
        public Having append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }

        @Override
        public InitClauseHaving clause(Object param) {
            return this.clauseIf(true, param);
        }

        public Having openPar() {
            QueryBuilder.this.openPar();
            return this;
        }
    }

    public class GroupBy
    extends Query
    implements Appendable<GroupBy>,
    CanLimit,
    CanOrder {
        private void init() {
            QueryBuilder.this.applyRegex();
            QueryBuilder.this.sb.append(!QueryBuilder.this.sb.toString().endsWith(" GROUP BY ") ? " GROUP BY " : ",");
        }

        private GroupBy(Alias<?> alias, Object ... properties) {
            this.init();
            this.add(alias, properties);
        }

        private GroupBy(Alias<?> ... alias) {
            this.init();
            this.add(alias);
        }

        private GroupBy(Param ... params) {
            this.init();
            this.add(params);
        }

        private GroupBy() {
            this.init();
            this.add(QueryBuilder.this.selectAliases.toArray(new Alias[0]));
        }

        public GroupBy add(Alias<?> alias, Object ... properties) {
            if (!QueryBuilder.this.sb.toString().endsWith(" GROUP BY ")) {
                QueryBuilder.this.sb.append(',');
            }
            QueryBuilder.this.sb.append(QueryBuilder.this.session.buildSelectImpl(((Alias)alias).config.getBeanClass(), ((Alias)alias).aliasStr, AnsiSQLBeanSession.getProperties(properties), null, false, false));
            return this;
        }

        public GroupBy add(Alias<?> ... aliases) {
            for (Alias<?> alias : aliases) {
                if (!QueryBuilder.this.sb.toString().endsWith(" GROUP BY ")) {
                    QueryBuilder.this.sb.append(',');
                }
                QueryBuilder.this.sb.append(QueryBuilder.this.session.buildSelectImpl(((Alias)alias).config.getBeanClass(), ((Alias)alias).aliasStr, ((Alias)alias).returns, ((Alias)alias).returnMinus, false, false));
            }
            return this;
        }

        public GroupBy add(Param ... params) {
            for (Param p : params) {
                if (!QueryBuilder.this.sb.toString().endsWith(" GROUP BY ")) {
                    QueryBuilder.this.sb.append(',');
                }
                this.append(p);
            }
            return this;
        }

        public Having having() {
            return new Having(true);
        }

        @Override
        public GroupBy append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }

        @Override
        public Order orderBy() {
            return new Order();
        }

        @Override
        public Limit limit(Object lim) {
            return new Limit(lim);
        }
    }

    public class Ordering
    extends Query
    implements CanLimit,
    Appendable<Ordering> {
        private boolean alreadyOrder = false;

        private void initOrder() {
            if (this.alreadyOrder) {
                QueryBuilder.this.sb.append(',');
            }
            this.alreadyOrder = true;
        }

        public Ordering asc(Param param) {
            this.initOrder();
            QueryBuilder.this.add(param);
            QueryBuilder.this.sb.append(param.paramInQuery()).append(" ASC ");
            return this;
        }

        public Ordering desc(Param param) {
            this.initOrder();
            QueryBuilder.this.add(param);
            QueryBuilder.this.sb.append(param.paramInQuery()).append(" DESC ");
            return this;
        }

        public Ordering asc(Alias<?> alias, Object ... properties) {
            this.iterateOrderBy(" ASC ", alias, properties);
            return this;
        }

        public Ordering desc(Alias<?> alias, Object ... properties) {
            this.iterateOrderBy(" DESC ", alias, properties);
            return this;
        }

        @Override
        public Limit limit(Object lim) {
            return new Limit(lim);
        }

        private void iterateOrderBy(String orderType, Alias<?> alias, Object[] properties) {
            String[] props = AnsiSQLBeanSession.getProperties(properties);
            this.initOrder();
            for (String prop : props) {
                QueryBuilder.this.sb.append(alias.toColumn(prop)).append(orderType).append(",");
            }
            QueryBuilder.this.sb.setCharAt(QueryBuilder.this.sb.length() - 1, ' ');
        }

        @Override
        public Ordering append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }
    }

    public class Order
    implements Appendable<Order> {
        private Order() {
            QueryBuilder.this.applyRegex();
            QueryBuilder.this.sb.append(" ORDER BY ");
        }

        public Ordering asc(Param param) {
            return new Ordering().asc(param);
        }

        public Ordering desc(Param param) {
            return new Ordering().desc(param);
        }

        public Ordering asc(Alias<?> alias, Object ... properties) {
            return new Ordering().asc(alias, properties);
        }

        public Ordering desc(Alias<?> alias, Object ... properties) {
            return new Ordering().desc(alias, properties);
        }

        @Override
        public Order append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }
    }

    public class Offset
    extends Query
    implements Appendable<Offset> {
        public Offset(Number offset) {
            this(offset != null && offset.longValue() > 0L ? new ParamValue(offset) : null);
        }

        public Offset(Param param) {
            if (param != null) {
                QueryBuilder.this.add(param);
                QueryBuilder.this.sb.append(" OFFSET ").append(param.paramInQuery());
            }
        }

        public Order orderBy() {
            return new Order();
        }

        @Override
        public Offset append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }
    }

    public class Limit
    extends Query
    implements CanOrder,
    Appendable<Limit> {
        private Limit(Object lim) {
            Param param = QueryBuilder.this.paramHandler.findBetter(QueryBuilder.this, lim);
            if (param != null) {
                Number numberLimit;
                QueryBuilder.this.applyRegex();
                QueryBuilder.this.add(param);
                Object numberObj = QueryBuilder.this.paramValues.get(QueryBuilder.this.paramValues.size() - 1);
                if (numberObj instanceof Number && (numberLimit = (Number)numberObj).longValue() <= 0L) {
                    QueryBuilder.this.paramValues.remove(QueryBuilder.this.paramValues.size() - 1);
                    return;
                }
                QueryBuilder.this.sb.append(" LIMIT ").append(param.paramInQuery());
            }
        }

        @Override
        public Order orderBy() {
            return new Order();
        }

        public Offset offset(Integer offset) {
            return new Offset(offset);
        }

        public Offset offset(Param param) {
            return new Offset(param);
        }

        @Override
        public Limit append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }
    }

    public abstract class EndClause
    extends Query
    implements CanOrder,
    CanLimit {
        protected void init(String condition) {
            QueryBuilder.this.sb.append(' ').append(condition);
        }

        @Override
        public Order orderBy() {
            return new Order();
        }

        @Override
        public Limit limit(Object lim) {
            return new Limit(lim);
        }
    }

    public class EndClauseHaving
    extends EndClause
    implements Appendable<EndClauseHaving> {
        private EndClauseHaving(Condition condition) {
            if (QueryBuilder.this.clauseIf) {
                QueryBuilder.this.add(condition);
                this.init(condition.build());
            }
        }

        private EndClauseHaving(String condition) {
            if (QueryBuilder.this.clauseIf) {
                this.init(condition);
            }
        }

        public EndClauseHaving openPar() {
            QueryBuilder.this.openPar();
            return this;
        }

        public EndClauseHaving closePar() {
            QueryBuilder.this.closePar();
            return this;
        }

        public Having and() {
            QueryBuilder.this.addAnd();
            return new Having(false);
        }

        public Having or() {
            QueryBuilder.this.addOr();
            return new Having(false);
        }

        @Override
        public EndClauseHaving append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }
    }

    public class EndClauseWhere
    extends EndClause
    implements Appendable<EndClauseWhere>,
    CanGroupBy {
        private EndClauseWhere(Condition condition) {
            if (QueryBuilder.this.clauseIf) {
                QueryBuilder.this.add(condition);
                this.init(condition.build());
            }
        }

        private EndClauseWhere(String condition) {
            if (QueryBuilder.this.clauseIf) {
                this.init(condition);
            }
        }

        public EndClauseWhere openPar() {
            QueryBuilder.this.openPar();
            return this;
        }

        public EndClauseWhere closePar() {
            QueryBuilder.this.closePar();
            return this;
        }

        public Where and() {
            QueryBuilder.this.addAnd();
            return new Where(false);
        }

        public Where or() {
            QueryBuilder.this.addOr();
            return new Where(false);
        }

        @Override
        public EndClauseWhere append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }

        @Override
        public GroupBy groupBy(Alias<?> ... aliases) {
            return new GroupBy((Alias[])aliases);
        }

        @Override
        public GroupBy groupBy(Param ... params) {
            return new GroupBy(params);
        }

        @Override
        public GroupBy groupByProp(Alias<?> alias, Object ... properties) {
            return new GroupBy(alias, properties);
        }

        @Override
        public GroupBy groupBy() {
            return new GroupBy();
        }
    }

    public class InitClause {
        private InitClause(Object param) {
            Param p = QueryBuilder.this.paramHandler.findBetter(QueryBuilder.this, param);
            if (QueryBuilder.this.clauseIf) {
                QueryBuilder.this.add(p);
                QueryBuilder.this.sb.append(' ').append(p.paramInQuery());
            }
        }
    }

    public class InitClauseHaving
    extends InitClause
    implements Appendable<InitClauseHaving>,
    HasEndClause<EndClauseHaving> {
        private InitClauseHaving(Object param) {
            super(param);
        }

        @Override
        public InitClauseHaving append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }

        @Override
        public EndClauseHaving condition(String condition) {
            return new EndClauseHaving(condition);
        }

        @Override
        public EndClauseHaving condition(Condition condition) {
            return new EndClauseHaving(condition);
        }
    }

    public class InitClauseWhere
    extends InitClause
    implements Appendable<InitClauseWhere>,
    HasEndClause<EndClauseWhere> {
        private InitClauseWhere(Object param) {
            super(param);
        }

        @Override
        public InitClauseWhere append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }

        @Override
        public EndClauseWhere condition(String condition) {
            return new EndClauseWhere(condition);
        }

        @Override
        public EndClauseWhere condition(Condition condition) {
            return new EndClauseWhere(condition);
        }
    }

    public class Where
    implements Appendable<Where>,
    HasInitClause<InitClauseWhere> {
        private Where(boolean init) {
            if (init) {
                QueryBuilder.this.sb.append(" WHERE ");
            }
        }

        @Override
        public InitClauseWhere clauseIf(boolean clauseIf, Object param) {
            QueryBuilder.this.clauseIf = clauseIf;
            return new InitClauseWhere(param);
        }

        @Override
        public Where append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }

        @Override
        public InitClauseWhere clause(Object param) {
            return this.clauseIf(true, param);
        }

        public Where openPar() {
            QueryBuilder.this.openPar();
            return this;
        }
    }

    public class Equals
    extends From {
        private Alias<?> aliasFK;
        private Alias<?> aliasPK;

        private Equals(Alias<?> aliasPK, Alias<?> aliasFK) {
            this.aliasPK = aliasPK;
            this.aliasFK = aliasFK;
        }

        public Equals eqPropertyForcingInstance(Object propertyBean) {
            ((Alias)this.aliasFK).put(propertyBean, true, (Alias)this.aliasPK);
            return this;
        }

        public Equals eqProperty(Object propertyBean) {
            ((Alias)this.aliasFK).put(propertyBean, false, (Alias)this.aliasPK);
            return this;
        }

        public OnEquals and(Object property) {
            return new On(this.aliasPK, false).on(property);
        }
    }

    public class OnEquals {
        private Alias<?> aliasPK;

        private OnEquals(Alias<?> aliasPK) {
            QueryBuilder.this.sb.append('=');
            this.aliasPK = aliasPK;
        }

        public Equals eq(Object property) {
            Alias alias = QueryBuilder.this.findAlias();
            QueryBuilder.this.sb.append(alias.toColumn(property));
            return new Equals(this.aliasPK, alias);
        }
    }

    public class PopulateUsing
    extends From {
        private Alias<?> aliasPK;
        private Alias<?> aliasFK;

        public PopulateUsing(Alias<?> aliasPK, Alias<?> aliasFK) {
            this.aliasFK = aliasFK;
            this.aliasPK = aliasPK;
        }

        public From inPropertyForcingInstance(Object propertyBean) {
            ((Alias)this.aliasFK).put(propertyBean, true, (Alias)this.aliasPK);
            return this;
        }

        public From inProperty(Object propertyBean) {
            ((Alias)this.aliasFK).put(propertyBean, false, (Alias)this.aliasPK);
            return this;
        }

        public From pkPropertyForcingInstance(Object propertyBean) {
            ((Alias)this.aliasPK).put(propertyBean, true, (Alias)this.aliasFK);
            return this;
        }

        public From pkProperty(Object propertyBean) {
            ((Alias)this.aliasPK).put(propertyBean, false, (Alias)this.aliasFK);
            return this;
        }
    }

    public class UsingPK {
        private Alias<?> aliasPK;

        private UsingPK(Alias<?> aliasPK) {
            this.aliasPK = aliasPK;
        }

        public PopulateUsing in(Alias<?> aliasFK) {
            this.buildOn(this.aliasPK, aliasFK);
            return new PopulateUsing(this.aliasPK, aliasFK);
        }

        private void buildOn(Alias<?> aPK, Alias<?> aFK) {
            Iterator<DBField> pks = ((Alias)aPK).config.pks();
            DBField df = pks.next();
            QueryBuilder.this.sb.append(((Alias)aPK).aliasStr).append(".").append(df.getDbName()).append(" = ").append(((Alias)aFK).aliasStr).append(".").append(df.getDbName());
            while (pks.hasNext()) {
                df = pks.next();
                QueryBuilder.this.sb.append(" AND ").append(((Alias)aPK).aliasStr).append(".").append(df.getDbName()).append(" = ").append(((Alias)aFK).aliasStr).append(".").append(df.getDbName());
            }
        }
    }

    public class On {
        private Alias<?> aliasPK;

        private On(Alias<?> aliasPK, boolean init) {
            QueryBuilder.this.sb.append(init ? " ON " : " AND ");
            this.aliasPK = aliasPK;
        }

        public OnEquals on(Object property) {
            QueryBuilder.this.sb.append(this.aliasPK.toColumn(property));
            return new OnEquals(this.aliasPK);
        }

        public UsingPK pkOf(Alias<?> alias) {
            return new UsingPK(alias);
        }
    }

    public class From
    extends Query
    implements CanOrder,
    CanLimit,
    CanGroupBy,
    Appendable<From> {
        private From(Alias<?> alias) {
            QueryBuilder.this.aliasFrom = alias;
            QueryBuilder.this.sb.append(" FROM ").append(((Alias)alias).config.getTableName()).append(" ").append(((Alias)alias).aliasStr);
        }

        private From() {
        }

        public On leftJoin(Alias<?> a) {
            return this.join(a, "LEFT JOIN");
        }

        public On rightJoin(Alias<?> a) {
            return this.join(a, "RIGHT JOIN");
        }

        public On join(Alias<?> a) {
            return this.join(a, "JOIN");
        }

        public On join(Alias<?> a, String joinType) {
            QueryBuilder.this.sb.append(" " + joinType + " ");
            QueryBuilder.this.appendTable(a);
            return new On(a, true);
        }

        public Where where() {
            return new Where(true);
        }

        @Override
        public Order orderBy() {
            return new Order();
        }

        @Override
        public Limit limit(Object lim) {
            return new Limit(lim);
        }

        @Override
        public From append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }

        @Override
        public GroupBy groupBy(Alias<?> ... aliases) {
            return new GroupBy((Alias[])aliases);
        }

        @Override
        public GroupBy groupByProp(Alias<?> alias, Object ... properties) {
            return new GroupBy(alias, properties);
        }

        @Override
        public GroupBy groupBy() {
            return new GroupBy();
        }

        @Override
        public GroupBy groupBy(Param ... p) {
            return new GroupBy(p);
        }
    }

    public class Select
    implements Appendable<Select> {
        private boolean init = false;

        private Select(String str) {
            QueryBuilder.this.sb.append("SELECT " + (str == null || str.isEmpty() ? "" : str + " "));
            QueryBuilder.this.selectAliases = new ArrayList();
        }

        private Select(String str, Alias<?> ... as) {
            this(str);
            this.add(as);
        }

        private Select(String str, Sentence ... sentences) {
            this(str);
            this.add(sentences);
        }

        public Select add(Sentence ... sentences) {
            for (Sentence s : sentences) {
                if (s.getName() == null || s.getName().isEmpty()) {
                    throw new BeanException("The sentence (" + s.build() + ") in SELECT clause must have a name");
                }
                if (this.init) {
                    QueryBuilder.this.sb.append(",");
                }
                QueryBuilder.this.sb.append(s.build()).append(' ').append(s.getName());
                QueryBuilder.this.sentences.put(s.getName(), s);
                QueryBuilder.this.add(s);
                this.init = true;
            }
            return this;
        }

        public Select add(Alias<?> ... as) {
            for (Alias<?> alias : as) {
                if (this.init) {
                    QueryBuilder.this.sb.append(",");
                }
                QueryBuilder.this.selectAliases.add(alias);
                QueryBuilder.this.sb.append(QueryBuilder.this.session.buildSelectImpl(((Alias)alias).config.getBeanClass(), ((Alias)alias).aliasStr, ((Alias)alias).returns, ((Alias)alias).returnMinus, false, true));
                this.init = true;
            }
            return this;
        }

        public From from(Alias<?> alias) {
            return new From(alias);
        }

        @Override
        public Select append(Param p) {
            QueryBuilder.this.append(p);
            return this;
        }
    }

    public class Alias<T> {
        private BeanConfig config;
        private String aliasStr;
        private T pxy;
        private String[] returns;
        private String[] returnMinus;
        private Map<Key, Alias> joined = new HashMap<Key, Alias>();

        private Alias(Class<? extends T> clazz, String aliasStr) {
            this.aliasStr = aliasStr;
            this.config = QueryBuilder.this.session.getConfigFor((Class<? extends Object>)clazz);
            if (this.config == null) {
                throw new BeanException("BeanConfig not found for " + clazz);
            }
            this.pxy = PropertiesProxy.create(this.config.getBeanClass());
            QueryBuilder.this.createdAliases.add(this);
        }

        public void setReturns(Object ... returns) {
            this.returns = AnsiSQLBeanSession.getProperties(returns);
        }

        public void setReturnMinus(Object ... returns) {
            this.returnMinus = AnsiSQLBeanSession.getProperties(returns);
        }

        public T pxy() {
            return this.pxy;
        }

        public String toColumn(Object property) {
            return QueryBuilder.this.session.propertyToColumn(this.config.getBeanClass(), property, this.aliasStr);
        }

        public void populateBean(ResultSet rs, T bean) {
            QueryBuilder.this.session.populateBeanImpl(rs, bean, this.aliasStr, this.returns, this.returnMinus, false);
        }

        public void populateAll(ResultSet rs, T bean) {
            this.populateBean(rs, bean);
            for (Map.Entry<Key, Alias> m : this.joined.entrySet()) {
                Object value;
                if (!QueryBuilder.this.selectAliases.contains(m.getValue()) || (value = QueryBuilder.this.session.getPropertyBean(bean, m.getKey().property, m.getKey().forceInstance)) == null) continue;
                m.getValue().populateAll(rs, value);
            }
        }

        public String toString() {
            return "Alias " + this.aliasStr + " of " + this.config.getBeanClass();
        }

        private void put(Object property, boolean forceInstance, Alias<?> alias) {
            this.joined.put(new Key().property(property).forceInstance(forceInstance), alias);
        }

        private class Key {
            private String property;
            private boolean forceInstance;

            private Key() {
            }

            public Key property(Object property) {
                this.property = AnsiSQLBeanSession.getProperties(new Object[]{property})[0];
                return this;
            }

            public Key forceInstance(boolean force) {
                this.forceInstance = force;
                return this;
            }
        }
    }
}

